proc align_frames {molecule selection} {
	set outfile [open rmsd.dat w]  
	set nf [molinfo $molecule get numframes]  

set frame0 [atomselect $molecule $selection frame 0]  

# rmsd calculation loop  

for { set i 1 } { $i <= $nf } { incr i } {  

set sel [atomselect $molecule $selection frame $i]
$sel move [measure fit $sel $frame0]
puts $outfile "[measure rmsd $sel $frame0]"
   
  }  

close $outfile
}

