#!/bin/bash

#PBS -P <project_id>
#PBS -q gpuvolta
#PBS -l ngpus=2
#PBS -l ncpus=24
#PBS -l mem=12gb
#PBS -l wd
#PBS -lstorage=scratch/<project_id>
#PBS -l walltime=05:00:00
#PBS -M <email>
#PBS -m abe
#PBS -j oe

ntmpi=4
ompthreads=6

export OMP_NUM_THREADS=$ompthreads
export GMX_DISABLE_GPU_TIMING=TRUE

module load gromacs

#This uses martini v2.2 forcefield
# 13. Run MD

gmx mdrun -cpi -ntomp $ompthreads -ntmpi $ntmpi -deffnm MD313 -nb gpu -v

# 14. Clean up trajectory file (MD.trr) by removing solvent
# removing non-alpha carbon 'atoms'
# and renaming the remaining alpha carbon atoms to CA
# (i.e. rename coarse grain CA to the non-coarse grain alpha carbon)
#source convert-to-CA-RAIJIN.sh
