#!/usr/bin/env python
# coding: utf-8

# In[1]:


import numpy as np
import matplotlib.pyplot as plt
import plotly.graph_objects as go
kdna = 0.001
katp = 0.0001
vmax = 8.3E-6
C0 = 2*10**-7
tend = 3000000
stopat99 = 'true'
t99 = 0




# In[2]:


zeros = np.zeros(100)
CD = np.array([C0]) #Startkonzentration DNA
CD = np.concatenate((CD,zeros)) #Vektor mit allen Konzentrationen
CA = 10**-4 #starting concentration ATP
t = 0 #time


def v(A,D):
    return ((vmax*CA*CD)/(kdna*katp+kdna*CA+katp*CD+CA*CD)*10**-3) #Änderung der DNA-Konzentration in Äbhängigkeit der DNA und ATP Konzentration

while t<= tend: #loop iterating over time
    v1 = v(CA,CD) #reaction velocity at t
    CD = CD-v1 #change of concentration is determined by reaction v(t)
    CD = np.concatenate((CD[0:1],CD[1:101]+v1[0:100])) 
    CA = CA-np.sum(v1) #decrease of ATP is equal to the sum of all DNA decreases
    if t==0:
        E0=CD
    if (t/200000)==3: # checkpoints to save the distribution at certain times
        E1=CD
    if (t/200000)==6:
        E2=CD
    if (t/200000)==9:
        E3=CD
    if (t/200000)==12:
        E4=CD
    if (t/200000)==15:
        E5=CD
    t = t+1
    


# In[4]:


x =np.arange(0,101,1) #arange 
#plt.plot(x,E1,label='600s')
plt.plot(x,E2,label='120s')
plt.plot(x,E3,label='180s')
plt.plot(x,E4,label='240s')
plt.plot(x,E5,label='300s')
plt.xlabel('strand length')
plt.ylabel('concentration')
plt.title('strand length distribution')
plt.xlim(left=0)
plt.legend()
plt.xlim(right=25)
plt.show() 


# In[ ]:





# In[ ]:




