%% make folder and files for all extension types
types = {'jpg'};

% make folder to put images in
for i = 1:length(types)
    mkdir(strcat(types{i}, '_files'));
    
    % make file to automatically store the file names in
    fileId = fopen(strcat(types{i}, '_files\',types{i},'TO_UPLOAD.txt'),'w');
    fprintf(fileId,'');
    fclose(fileId);
    
    % make file to store the links
    fileLinks = fopen(strcat(types{i}, '_files\',types{i},'LINKS.txt'),'w');
    fprintf(fileLinks,'');
    fclose(fileLinks);
    
end

%%  move and rename files
igem_specic_name = 'T--Chalmers-Gothenburg--';

for i = 1:length(types)
    list = ls(strcat('*.', types{i})); % list all files for a specific extension
    n_files = size(list, 1);
    
    disp(strcat('Working with \ ', types{i}, ' files'))
    
    for file_id = 1: n_files
        disp(strcat('--Working with image \ ', list(file_id,:)))
        
        source = list(file_id,:);
        
        new_filename = strcat(igem_specic_name, source);
        
        dest = strcat('./',types{i}, '_files/', new_filename);
        movefile(source, dest);
        
        fileId = fopen(strcat(types{i}, '_files\',types{i},'TO_UPLOAD.txt'),'a+');
        fprintf(fileId, strcat(new_filename, '\n'));
        fclose(fileId);
    
    end
end

%% open a webbrowser for each file

upload_url = 'https://2021.igem.org/Special:Upload';
list = ls('png_files/*.png'); % list all files for a specific extension
n_files = size(list, 1);

for i = 1:5
   web(upload_url, '-new') 
end

%% 
linksPNG = { ...
'https://2021.igem.org/wiki/images/6/69/T--Chalmers-Gothenburg--thrtranscriptome.jpg',...
'https://2021.igem.org/wiki/images/b/bd/T--Chalmers-Gothenburg--Verena01.jpg',...
'https://2021.igem.org/wiki/images/0/0c/T--Chalmers-Gothenburg--ProcF-unsync-groupPicture.JPG',...
'https://2021.igem.org/wiki/images/5/5d/T--Chalmers-Gothenburg--ProcF-cool-groupPicture.JPG',...
'https://2021.igem.org/wiki/images/c/c7/T--Chalmers-Gothenburg--NiC-groupPicture.jpg',...
'https://2021.igem.org/wiki/images/f/f5/T--Chalmers-Gothenburg--Chalmers-Linkan-better.jpg',...
'https://2021.igem.org/wiki/images/3/3b/T--Chalmers-Gothenburg--Angelo01.jpg',...
'https://2021.igem.org/wiki/images/3/3c/T--Chalmers-Gothenburg--Andrea01.jpg',...
};

HTML_PNG = fopen('PNG_HTML.txt','w');


for i = 1:length(linksPNG)
    fprintf(HTML_PNG, strcat(...
    '<div class="container">\n',...
    '     <div class="row justify-content-center">\n',...
    '	    <div class="col-md-12 col-lg-10 offset-md-1 offset-lg-0 border">\n',...
    '		    <figure>\n',...
    '			    <img class="img-fluid" src="',linksPNG{i},'">\n',...
    '			    <figcaption class="caption">\n',...
    '				    [[Caption]]\n',...
    '			    </figcaption>\n',...
    '		    </figure>\n',...
    '	    </div>\n',...
    '   </div>\n',...
    '</div>\n\n'));
end

fclose(HTMLPNG);
disp('done')

%%
linksPDF = {...
'https://2021.igem.org/wiki/images/b/b9/T--Chalmers-Gothenburg--MAN0013117_GeneJET_Plasmid_Miniprep_UG.pdf',...
'https://2021.igem.org/wiki/images/0/04/T--Chalmers-Gothenburg--Phusion_PCR_Protocol.pdf',....
'https://2021.igem.org/wiki/images/d/d5/T--Chalmers-Gothenburg--PrimeStar_PCR.pdf',....
'https://2021.igem.org/wiki/images/9/90/T--Chalmers-Gothenburg--Protocols_gibson_assembly-print_p13-15.pdf',...
'https://2021.igem.org/wiki/images/1/12/T--Chalmers-Gothenburg--Protocol_Sysbio_Plates_and_Media.pdf',...
'https://2021.igem.org/wiki/images/3/35/T--Chalmers-Gothenburg--Yeast_Screening_protocol.pdf',...
'https://2021.igem.org/wiki/images/1/1e/T--Chalmers-Gothenburg--MAN0012661_GeneJET_Gel_Extraction_UG_%%281%%29.pdf',...
'https://2021.igem.org/wiki/images/7/7d/T--Chalmers-Gothenburg--MAN0012662_GeneJET_PCR_Purification_UG.pdf',...
'https://2021.igem.org/wiki/images/b/b5/T--Chalmers-Gothenburg--LiAc_transformation_protocol.pdf',...
'https://2021.igem.org/wiki/images/2/2c/T--Chalmers-Gothenburg--Guava_quick_guide_2021.pdf',...
'https://2021.igem.org/wiki/images/e/e9/T--Chalmers-Gothenburg--FastDigest_Restriction_Enzymes.pdf',...
'https://2021.igem.org/wiki/images/1/16/T--Chalmers-Gothenburg--Chemical_recipes.pdf',...
'https://2021.igem.org/wiki/images/6/65/T--Chalmers-Gothenburg--Delft_Medium.pdf',...
'https://2021.igem.org/wiki/images/8/80/T--Chalmers-Gothenburg--E_coli_transformation.pdf',...
};

HTML_PDF = fopen('PDF_HTML.txt','w');

for i = 1:length(linksPDF)
    strs = strsplit(linksPDF{i}, '/'); 
    fprintf(HTML_PDF, strcat(...
                    '<details>\n', ...
                    '  <summary>', strs{end},'</summary>\n', ...
                    '  <embed src="', linksPDF{i}, '" style="margin-left:10%%;" width="80%%" height="500px"/>\n', ...
                    '</details>\n\n'));
end

fclose(HTML_PDF);
disp('done')
% 
% <details>
% <summary> Risk decleration Induction systems </summary>
% <a href="https://2021.igem.org/wiki/images/5/57/T--Chalmers-Gothenburg--Risk_Declaration_Form_2.9.docx" download>Download docx File</a>    
% </details>