%The motion model of bacteria with GUI
clc
clear all
close all
%===========================
%build the GUI
%define the plot button

imh = figure('Visible','off','Position',[360,500,450,285]);
set(imh,'Name','model')
movegui(imh,'center')
set(imh,'Visible','on');

plotbutton=uicontrol('Style','pushbutton','String','Run', 'Fontsize',12, 'Position',[315,200,70,25], 'Callback', 'run=1;');
%define the stop button
erasebutton=uicontrol('style','pushbutton','string','Stop', 'fontsize',12, 'position',[315,160,70,25], 'callback','freeze=1;');
%define the Quit button
quitbutton=uicontrol('style','pushbutton','string','Quit', 'fontsize',12, 'position',[315,120,70,25], 'callback','stop=1;close;');
loadbutton=uicontrol('style','pushbutton','string','Load', 'fontsize',20, 'position',[315,50,70,25], 'callback','load=1;');


number = uicontrol('style','text', 'string','1', 'fontsize',20, 'position',[315,230,120,30]);
global ha
ha = axes('Units','pixels','Position',[50,60,200*1.2,185*1.15]);
align([plotbutton,erasebutton,quitbutton,loadbutton,number],'Center','None');
set([ha,plotbutton,erasebutton,quitbutton,loadbutton,number],'Units','normalized');
%==============================
%CA setup
n=128 * 2;
n2 = 128 * 2 ;
%initialize the arrays
z = zeros(n,n2);
global cells
cells = z;
sum = z;

%cells = (sum==3) | (sum==2 & cells);
load = 0;
stop= 0; %wait for a quit button push
run = 0; %wait for a draw
freeze = 0; %wait for a freeze
%read the picture
a = 1;

while (a == 1)
if (load == 1)
	
	[filename, pathname] = uigetfile({'*.jpg;*.tif;*.png;*.gif','All Image Files';'*.*','All Files' });
	I = imread([ pathname,filename]);
%I = imread('Rabbit2-2.jpg');
Z2 = rgb2gray(I);
Z1 = imresize(Z2,[n n2]);
t = graythresh(Z1);
Z = im2bw(Z1,t);

%change the picture
a_1 = find(Z == 0);
a_2 = find(Z == 1);
Z(a_1) = 1;
Z(a_2) = 0;

Z = 0.3 * Z;


set(imh,'WindowButtonDownFcn',@ButttonDownFcn);

%set a few cells to one

%cells((n/2-3),(n/2-1):(n/2+1)) = 10/500;
%cells((n/2-2),(n/2-2):(n/2+2)) = 10/500;
%cells((n/2-1),(n/2-3):(n/2+3)) = 10/500;
%cells((n/2),(n/2-3):(n/2+3)) = 10/500;
%cells((n/2+1),(n/2-3):(n/2+3)) = 10/500;
%cells((n/2+2),(n/2-2):(n/2+2)) = 10/500;
%cells((n/2+3),(n/2-1):(n/2+1)) = 10/500;

%cells(.25*n:.75*n,n/2) = 1;
%cells(.5*n-1,.5*n-1)=1;
%cells(.5*n-2,.5*n-2)=1;
%cells(.5*n-3,.5*n-3)=1;
%  cells = (rand(n,n))<.5 ;
%how long for each case to stability or simple oscillators
%build an image and display it
imh = image(cat(3,cells,z,Z));
set(imh, 'erasemode', 'none')
axis equal
axis tight
    a = 0;
end
    if (stop == 1)
        break;
    end
	drawnow
end


%index definition for cell update
x = 2:n-1;
y = 2:n2-1;
%Main event loop

while (stop==0)

if (run==1)
%nearest neighbor sum
sum(x,y) = ceil(cells(x, y-1))  + ceil(cells(x, y+1) ) + ...
           ceil(cells(x-1, y))  + ceil(cells(x+1, y)) + ...
           ceil(cells(x-1,y-1)) + ceil(cells(x-1, y+1)) + ...
           ceil(cells(x+1,y-1)) + ceil(cells(x+1, y+1));
%The CA rule
%cells = (sum==3) | (sum==2 & cells);

%fz
cells(x, y) = cells(x,y) * 1.05 + cells(x,y)*0.02;

cells(x, y) = cells(x,y) * 1.3  + cells(x,y)*0.02;

cells(x, y) = cells(x,y) + cells(x,y) * 0.02;

ddd = find(cells(:) > 1);
cells(ddd) = 1 ;


%move
% i1=ceil(3*rand(1));
% j1=ceil(3*rand(1));
% if (i1==1)
%     i=-1;
% end
% if (i1==2)
%     i=0;
% end
% if (i1==3)
%     i=1;
% end
% if (j1==1)
%     j=-1;
% end
% if (j1==2)
%     j=0;
% end
% if (j1==3)
%     j=1;
% end

mmm = cells ;
im = find(mmm(:) ~= 0);
 %cells2 = z;
 %cells3 = z;
 %cells2(x,y) = (sum(x,y) ~= 8 & sum(x,y) ~= 0 & ceil(cells(x,y)) == 1  & Z(x,y) ~= 0);
 %cells3(x+i,y+j) = (sum(x,y) ~= 8 & sum(x,y) ~= 0 & ceil(cells(x,y)) == 1  & Z(x,y) ~= 0);


BW1 = edge(cells,'canny') ;
BW2 = BW1;
%[a,b] = find (sum(x,y) ~= 8 & sum(x,y) ~= 0 & cells(x,y) ~= 0  & Z(x,y) ~= 0);
for tiqu = 2 : 1 : n - 1
    for tiqu2 = 2 : 1 : n2 - 1
        if BW2(tiqu,tiqu2) ~= 0
            BW1(tiqu - 1 : tiqu + 1 , tiqu2 - 1 : tiqu2 + 1 ) = 1 ;
        end
    end
end
BW1(a_2) = 0 ;
double(BW1);

%bian = find ( BW1(x,y) ~= 0  );
%BW1(bian - n -1 : bian + n +1) = 1;

bbb1 = find ( cells(:) ~= 0  );
bbb2 = find ( Z(:) ~= 0  );
bbb3 = find ( BW1(:) ~= 0  );

bbb4 = intersect(bbb1, bbb2);
bian = intersect(bbb4, bbb3);
bian = bian';
bian2 = 0;
for jjj = 1 : 1 : max(size(bian)) 

i1 = ceil(9*rand(1));

%(j-1)*m+i
if (i1==1)
    i=-n-1;
end
if (i1==2)
    i=-n;
end
if (i1==3)
    i=-n+1;
end
if (i1==4)
    i=-1;
end
if (i1==5)
    i=0;
end
if (i1==6)
    i=1;
end
if (i1==7)
    i=n-1;
end
if (i1==8)
    i=n;
end
if (i1==9)
    i=n+1;
end



bian2(jjj) = bian(jjj) + i ;

end

cells(bian) = 0.2 * mmm(bian);
cells(bian2) = cells(bian2) + 0.8 * mmm(bian);

%ttt = sub2ind(size(cells),a,b);
 %ttt1 = find (cells2(:) ~= 0);
 %ttt2 = find (cells3(:) ~= 0);
 %cells(ttt1) = 0.2 * mmm(ttt1);

%a2 = a+1;
%b2 = b-1;
%ttt2 = sub2ind(size(cells),a2,b2);
 %cells(ttt2) = cells(ttt2) + 0.8 * mmm(ttt1);

  cells(im) = mmm(im);
%dead
cells(x, y) = cells(x,y) / 1.53 + cells(x,y)/20;

ddd = find( cells(:) > 1 );
cells(ddd) = 1 ;

%draw the new image
set(imh, 'cdata', cat(3,z,cells,Z) )
%update the step number diaplay
stepnumber = 1 + str2num(get(number,'string'));
set(number,'string',num2str(stepnumber))

end

if (freeze == 1)
run = 0;
freeze = 0;
end



drawnow  %need this in the loop for controls to work
%pause(5);
end







