import levenshtein
import orcDecode

def findByORC(wordToFix, lexicon):
    sameORC = [seq[1][4] + seq[1][7:11] for seq in lexicon if orcDecode.extractORC(seq[1]) == orcDecode.extractORC(wordToFix)]
    word = orcDecode.extractword(wordToFix)
    levDist = [levenshtein.levenshtein(word, possible) for possible in sameORC]
    levPerPossible = min(zip(sameORC, levDist), key=lambda x: x[1])
    return wordToFix[:4] + levPerPossible[0][0] + 'CC' + levPerPossible[0][1:] + wordToFix[11:]