from traits.api import HasTraits, File, Range, Float, Button, Instance
from traitsui.api import View, Item, FileEditor, RangeEditor, VGroup
from tvtk.pyface.scene_editor import SceneEditor
from mayavi.tools.mlab_scene_model import MlabSceneModel
from mayavi.core.ui.mayavi_scene import MayaviScene
import numpy as np
import cv2
import mayavi.mlab as mlab


class pde():
        def __init__(self):
                self.nx = 20;
                self.ny = 20;
                self.dx = 0.1
                self.dy = 0.1;
                self.x_len = int(self.nx/self.dx)
                self.y_len = int(self.ny/self.dy)
                self.p_init = 100

        def img_load(self, url):
                self.img = cv2.imread(url, cv2.IMREAD_GRAYSCALE)
                ret, self.img = cv2.threshold(self.img, 127, 255, cv2.THRESH_BINARY_INV)
                
        def solver(self, time, k_value, r_value, ps_value):
                nt = time
                dt = 1
                p_pre = np.zeros((self.x_len, self.y_len))
                p_pre[self.x_len/2, self.y_len/2] = self.p_init
                k = self.img/255
                k = k*k_value
                print np.max(k)

                p_pre_up = np.zeros((self.x_len, self.y_len))
                p_pre_down = np.zeros((self.x_len, self.y_len))
                p_pre_left = np.zeros((self.x_len, self.y_len))
                p_pre_right = np.zeros((self.x_len, self.y_len))

                for t in range(nt):
                        p_pre_up[1:self.x_len-1, 1:self.y_len-1] = p_pre[:self.x_len-2, 1:self.y_len-1]
                        p_pre_down[1:self.x_len-1, 1:self.y_len-1] = p_pre[2:self.x_len, 1:self.y_len-1]
                        p_pre_left[1:self.x_len-1, 1:self.y_len-1] = p_pre[1:self.x_len-1, :self.y_len-2]
                        p_pre_right[1:self.x_len-1, 1:self.y_len-1] = p_pre[1:self.x_len-1, 2:self.y_len]
                        p_aft = (k*(p_pre_up+p_pre_down+p_pre_left+p_pre_right-4*p_pre)+r_value*p_pre*(1-p_pre/ps_value))*dt+p_pre
                        p_aft[0,:] = 0
                        p_aft[self.x_len-1,:] = 0
                        p_aft[:,0] = 0
                        p_aft[:,self.y_len-1] = 0
                        p_pre = p_aft.copy()

                        if t%60 == 0:
                                p0 = p_pre*255/np.max(p_pre)
                                p0 = np.uint8(p0)
                                ret, p0 = cv2.threshold(p0, 100, 255, cv2.THRESH_BINARY_INV)
                                edges = cv2.Canny(p0, 100, 100)
                                edges = cv2.bitwise_and(p0, p0, mask = self.img)
                                kernel = np.ones((5,5), np.uint8)
                                k = cv2.dilate(edges, kernel, iterations = 1)
                                k = cv2.bitwise_and(k, k, mask = self.img)
                                k = k*(5e-3)/255
                                print t
                return p_pre
                

class mainui(HasTraits):
        submitbutton = Button(u"ok")
        file_dir = File()
        k = Range(0, 0.010)
        r = Range(0.0001, 0.0005)
        ps = Range(1000, 3000)
        scene = Instance(MlabSceneModel, ())
        time = Range(3600, 3600*48)
        mod = Range(2, 3)


        view = View(
                Item(name = 'file_dir', label = 'Choose File'),
                Item('_'),
                Item(name = 'k', label = 'k', style = 'simple'),
                Item(name = 'r', label = 'r', style = 'simple'),
                Item(name = 'ps', label = 'ps', style = 'simple'),
                Item(name = "time", label = "time", style = "simple"),
                Item(name = 'mod', label = '2&3 D', style = 'simple'),
                
                VGroup("submitbutton", Item(name = "scene", editor = SceneEditor(scene_class = MayaviScene),
                        resizable = True, height = 250, width = 400), show_labels = False),
                title = "BioPaFiAR"
                )

        def __init__(self, pde):
                self.pde = pde
                self.k = 0.005
                self.r = 3.89e-4
                self.ps = 1500
        def _submitbutton_fired(self):
                if self.file_dir == "":
                        pass
                else:
                        
                        camera = self.scene.scene.camera
                        camera.parallel_scale = 90
                        self.plot()


        def plot(self):
                x, y = np.ogrid[0:pde.dx:pde.nx, 0:pde.dy:pde.ny]
                self.scene.mlab.clf()
                self.pde.img_load(self.file_dir)
                p_pre = self.pde.solver(self.time, self.k, self.r, self.ps)
                if self.mod == 2:
                        pl = mlab.imshow(p_pre)
                else:
                        pl = mlab.surf(x, y, p_pre, warp_scale = 'auto')
                        mlab.show()
                
                
pde = pde()
app = mainui(pde)
app.configure_traits()

