import cv2
import numpy as np
from PiRapidStream import PiRapidStream
from time import sleep
from multiprocessing.dummy import Pool
from TheSquaire import TheSquaire
###################################################################################################

def nothing(x):
    pass


def main():

    print("[INFO] sampling THREADED frames from `picamera` module...")
    vs = PiRapidStream(resolution=(576,512),fps=30,form='yuv',exp=30000,gain=1.15)
    vs.startcapt()
    cv2.namedWindow("detection", cv2.WINDOW_AUTOSIZE)
    cv2.createTrackbar('minr','detection',30,255,nothing)
    cv2.createTrackbar('maxr','detection',70,255,nothing)
    cv2.createTrackbar('accres','detection',100,1000,nothing)
    cv2.createTrackbar('upcanny','detection',200,255,nothing)
    cv2.createTrackbar('thres','detection',70,255,nothing)
    p=Pool(processes=4)
    ts=TheSquaire()



    while cv2.waitKey(1) != ord("q") and vs.stream_done==False:            
        img = vs.frame            
        grau=cv2.medianBlur(img,1)
        minr=cv2.getTrackbarPos('minr','detection')
        maxr=cv2.getTrackbarPos('maxr','detection')
        accres=cv2.getTrackbarPos('accres','detection')/100.0
        upc=cv2.getTrackbarPos('upcanny','detection')
        th=cv2.getTrackbarPos('thres','detection')
        circ=ts.kreise(x=(grau,minr,maxr,accres,upc,th))
        ts.zeichne_kreise(result=circ,dst=[img])
        #result=p.map(ts.kreise,[(grau,38,43,2.3,60,120),(grau,30,33,1,80,40),(grau,19,23,1.4,60,30),(grau,8,14,1.9,80,40)],chunksize=1)


        
       
        cv2.imshow('detection',img)


    cv2.destroyAllWindows()
    p.close()
    p.join()
    vs.stopcapt()
 
    print "quit"

    return

###################################################################################################
if __name__ == "__main__":
    main()
