import RPi.GPIO as GPIO
import time

GPIO.setmode(GPIO.BCM)
enable_pin=18
coilA1=4
coilA2=17
coilB1=23
coilB2=24

#GPIO.setup(enable_pin,GPIO.OUT)
GPIO.setup(coilA1,GPIO.OUT)
GPIO.setup(coilA2,GPIO.OUT)
GPIO.setup(coilB1,GPIO.OUT)
GPIO.setup(coilB2,GPIO.OUT)

#GPIO.output(enable_pin,1)

def forward(delay,steps):
    for i in range(0,steps):
        setStep(1,0,1,0)
        time.sleep(delay)
        setStep(0,1,1,0)
        time.sleep(delay)
        setStep(0,1,0,1)
        time.sleep(delay)
        setStep(1,0,0,1)
        time.sleep(delay)

def backwards(delay,steps):
    for i in range(0,steps):
        setStep(1,0,0,1)
        time.sleep(delay)
        setStep(0,1,0,1)
        time.sleep(delay)
        setStep(0,1,1,0)
        time.sleep(delay)
        setStep(1,0,1,0)
        time.sleep(delay)

def setStep(w1,w2,w3,w4):
    GPIO.output(coilA1,w1)
    GPIO.output(coilA2,w2)
    GPIO.output(coilB1,w3)
    GPIO.output(coilB2,w4)

while True:
    setStep(0,0,0,0)
    delay=raw_input("Delay between steps in ms:")
    steps=raw_input("One step forward:")
    forward(int(delay)/1000.0,int(steps))
    setStep(0,0,0,0)
    steps=raw_input("Two steps back:")
    backwards(int(delay)/1000.0,int(steps))
    
