/*
  ---------------------Centrifuge------------------------------------------------------------

  This program control the speed of the centrifuge.

  --------------------Usage guide----------------------------------------------------------------

  Program the arduino and mount the circuit. The circuit is on the following link:

  Make sure that all components are in the right place and well conected.

  The centrifuge circuit is conected to the arduino through the following pins:

   The signal pin of the tachometer is connected to the analog pin 0
   the pwm pin of teh ESC is conectted to the digital pin 9
   Voltage divider attached to analog pin 0.

  Open the serial monitor at 9600 baud. The Arduino will send a message saying it is ready .
  Then send the value of the speed ref in rpm.

  created 2016
  by Fernando Nóbel Santos Navarro <fersann1@upv.es>

  This example code is in the public domain.

*/
#include<Servo.h>//Library to control the ESC

Servo ESC; //Create an object of the class servo

int sens = 75; // this value indicates the limit reading between dark and light,
// it has to be tested as it may change acording on the
// distance the thacometer is placed
int nPalas = 1; // the number of blades of the propeller
int ts = 500; // the time it takes each reading. Sampling time.
int rpmRef = 0;// Reference for speed in RPM
int rpmRead;

float Kp = 10.0;
float Ki = 0.2;
float E = 0.0;

void setup()
{
  ESC.attach(9);//Attach the ESC to digital pin 9

  //Activate the ESC
  ESC.writeMicroseconds(1000); //1000 = 1ms
  //Change the 1000 before to 2000 if
  //your ESC activates with a pulse of 2ms

  delay(5000); //Wait 5 seconds to start the ESC

  Serial.begin(9600);//Start serial comunication
  Serial.println("Ready");
}

void loop()
{
  rpmRead = readRPM();

  if (Serial.available() >= 1)
  {
    rpmRef = Serial.parseInt(); //Leer un entero por serial
  }
  controlPI();
  Serial.print("RPM read: ");
  Serial.print(rpmRead);
  Serial.print("RPM ref: ");
  Serial.println(rpmRef);
}

void controlPI() {
  int u = 0;
  int e = rpmRef - rpmRead;

  E += Ki * e;
  u = Kp * e + 1000 + Ki * e;

  if (u > 2000) {
    u = 2000;
    E -= Ki * e;
  }
  if (u < 1000) {
    u = 1000;
    E -= Ki * e;
  }

  ESC.writeMicroseconds(u); //Send control action
}

int readRPM() {
  int counter = 0;
  long start = millis();
  int val;
  int stat = LOW;
  int stat2;
  int rpm;

  while (( millis() - start ) < ts) {
    val = analogRead(0);
    if (val < sens) {
      stat = LOW;
    }
    else {
      stat = HIGH;
    }
    if (stat2 != stat) { //counts when the state change, thats from (dark to light) or
      //from (light to dark), remmember that IR light is invisible for us.
      counter++;
      stat2 = stat;
    }
  }

  rpm = ((int)counter / nPalas) / 2.0 * 60000.0 / (ts);

  return rpm;
}
