//-------------------------Definiciones------------------------------------------------
const float maxError = 0.5; // Máximo error de temperatura aceptable. Tanto superior como inferior

const int S_OFF = 0;
const int S_WARM = 1;
const int S_COOL = 2;
const int S_KEEP = 3;

//-------------------------Variables---------------------------------------------------
float At = 0.1; // Sampling time in seconds
float temp; // Temperatura en ºC medida
float temp1; // Temperatura instante anterior en ºC
float dTemp = 0.0; // Derivative of the temperature in ºC/seg
float ref; // Refrencia en ºC a alcanzar
float e; // Error en ºC con respecto a la referencia
float E; //Integral of the error signal. Depends of the sampling time.
float u; // Accion de control aplicada
int controlState; // Estado del control
float timeDelay = 4.8; //Delay of the peltier in seconds
int state;

//-------------------------Inicializacion----------------------------------------------
void iniControlTemp() {
  ref = 25.0;// Just in case we dont set a ref value.
  e = 0.0;
  E = 0.0;
  u = 0.0;
  temp = readTemperatura();
  temp1 = temp;
  state = S_OFF;
}
//-------------------------Main Function----------------------------------------------
void controlTemp() {
  updateState();
  control_P_Pre();
  //control_PI();
  //  switch (state)
  //  {
  //    case S_OFF:
  //      Peltier_applyPower( 0 );
  //      break;
  //    case S_WARM:
  //      control_PD_Warm();
  //      break;
  //    case S_COOL:
  //      //control_PD_Cool();
  //      control_P_Pre();
  //      break;
  //    case S_KEEP:
  //      control_PI_Stabilize();
  //      break;
  //  }

}
//-------------------------Functions---------------------------------------------------
void setRef( float newRef) {
  ref = newRef;
  updateState();
  if (e > 0) {
    state = S_WARM;
  } else {
    state = S_COOL;
  }
  E = 0;
}
float get_e() {
  return e;
}
void updateState() {
  temp1 = temp;
  temp = readTemperatura();
  e = ref - temp;
  filterLP();
  estimateDerivative();
  if (state != S_OFF) {
    if (state == S_COOL) {
      if (u == 0.0) {
        state = S_WARM;
      }
    }
  }
}
//-------------------------Controles Genéricos-----------------------------------------
void control_PD() {
  float Kp = 10.0;
  float Kd = 40.0;

  u =  Kp * e - Kd * dTemp;

  if ( u > 255) {
    u = 255;
  }
  if ( u < -255) {
    u = -255;
  }
  Peltier_applyPower( u );
}
void control_PI() {
  float Kp = 10.0;
  float Ki = 0.25;

  E += e * At;

  u =  Kp * e + Ki * E;

  if ( u > 255) {
    E -= e * At;
    u = 255;
  }
  if ( u < -255) {
    u =  Kp * e + Ki * E;
    u = -255;
  }
  Peltier_applyPower( u );
}
//-------------------------PD Especialized controls---------------------------------
void control_P_Pre() {
  float Kp = 10.0;//10.0
  float Kd = 80.0;//100.0
  float Ki = 0.0;//0.4
  if (ref == 63.00) {
    Kd = 60.0;
  }
  if (e < 0) {
    Ki = 0.0;
  }
  E += e * At;

  //u =  Kp * e + - Kd * dTemp + Ki * E + 2.949 * temp - 113.5;
  u =  Kp * e + - Kd * dTemp + Ki * E + 2.61 * ref - 91.29;

  if ( u > 255) {
    E -= e * At;
    u = 255;
  }
  if ( u < -255.0) {
    u = -255.0;
    E -= e * At;
  }
  Peltier_applyPower( u );
}
void control_PD_Warm() {
  float Kp = 15.0;//10.0
  float Kd = 100.0;//100.0
  float Ki = 0.3;//0.4

  E += e * At;

  u =  Kp * e - Kd * dTemp + Ki * E;

  if ( u > 255) {
    E -= e * At;
    u = 255;
  }
  if ( u < 0.0) {
    u = 0.0;
  }

  Peltier_applyPower( u );
}
void control_PD_Cool() {
  float Kp = 10.0;
  float Kd = 100.0;
  float Ki = 0.4;

  E += e * At;

  u =  Kp * e - Kd * dTemp + Ki * E;

  if ( u > 0) {
    E -= e * At;
    u = 0;
  }
  if ( u < -255) {
    E -= e * At;
    u = -255;
  }

  Peltier_applyPower( u );
}
//-------------------------PI Especialized control----------------------------------
void control_PI_Stabilize() {
  float Kp = 10.0;
  float Ki = 0.25;

  E += e * At;

  u =  Kp * e + Ki * E  + 1.634 * (ref - 25.0);

  if ( u > 255) {
    E -= e * At;
    u = 255;
  }
  if ( u < 0) {
    u =  Kp * e + Ki * E;
    u = 0;
  }
  Peltier_applyPower( u );
}
//-------------------------Filtro---------------------------------------------------
void filterLP() {
  temp = 0.5 * temp + 0.5 * temp1;
}
//-------------------------Derivative Estimator-------------------------------------
void estimateDerivative() {
  dTemp = 0.94 * dTemp + 0.06 * (temp - temp1) / At;
}
//-------------------------Serial Comunication--------------------------------------
void serialInform() {
  Serial.print("T: ");
  Serial.print(temp);
  Serial.print(" C , Ref: ");
  Serial.print(ref);
  Serial.print(" C , Error: ");
  Serial.print(e);
  //  Serial.print(" C , State: ");
  //  Serial.print(controlState);
  Serial.println();
}







































