//-------------------------Definiciones------------------------------------------------

//-------------------------Pin---------------------------------------------------------
const int rele_1Pin = 7;// Rele 1 conectado a la peltier y a +5V y GND
const int rele_2Pin = 6;// Rele 2 conectado a la peltier y a +5V y GND
const int potenciaPin = 5;// PWM que controlará la potencia en la peltier
//-------------------------Inicializacion----------------------------------------------
void iniPeltier() {
  pinMode(rele_1Pin, OUTPUT);
  pinMode(rele_2Pin, OUTPUT);
  pinMode(potenciaPin, OUTPUT);
  Peltier_OFF();
  digitalWrite(potenciaPin, LOW);
}
//-------------------------Funciones---------------------------------------------------
void Peltier_OFF() {
  //Turn-off the peltier.
  digitalWrite(rele_1Pin, LOW);
  digitalWrite(rele_2Pin, LOW);
}
void Peltier_HOT() {
  //Swicth the relay to warm he peltier
  digitalWrite(rele_1Pin, LOW);
  digitalWrite(rele_2Pin, HIGH);

}
void Peltier_COLD() {
  //Swicth the relay to cool the peltier
  digitalWrite(rele_1Pin, HIGH);
  digitalWrite(rele_2Pin, LOW);

}
void Peltier_setPower(int power) {
  //Set the power apllyed to the peltier
  analogWrite(potenciaPin, 255 - power );
}
void Peltier_applyPower(int power) {
  //This function control the energy applyied to the peltier.
  //If power is negative the peltier will cool, and if it is positive, it will warm.
  // power = 255 -> Maximun power heating.
  // power = 0 -> Peltier off.
  // power = -255 -> Maximun power cooling.
  if (power > 0) {
    Peltier_HOT();
  }
  if (power < 0) {
    Peltier_COLD();
  }

  power = abs(power);

  if (power > 255) {
    power = 255;
  }
  if (power < 0.0) {
    power = 0;
  }
  Peltier_setPower( power );
}

















