%% A function that makes the values in an image outside the circular ROI equal to NaN. 
% use: roi_circ(the image, Region of Interest). 
% the region of interest is the structure which has the following information: 
% roi.xs , roi.ys (start); roi.dx, roi.dy (difference) roi.xe, roi.ye (end)
% roi.x roi.y (dimensional arrays); roi.r (radius)
% made by J.F.Kooijman 24-9-2013

function imagec = roi_circ(image,roi)        
    imagec = image(roi.y,roi.x);
    for i = 1:roi.dy+1
        for j = 1:roi.dx+1
            x = -roi.dx/2 + j;
            y = roi.dy/2 - i;
            if (sqrt(x^2+y^2)> roi.r)
                imagec(i,j) = NaN;
            end
        end
    end
end