%% Paste rows together 
% made by J.F.Kooijman 24-9-2013

function [image_tot,marker] = merge_rows(im_top,im_bot,displacementy,displacementx,markerside,markerposition) 
    [rows_top, cols_top] = size(im_top);
    [rows_bot, cols_bot] = size(im_bot);
    
    if(markerside=='r')
        im_top = fliplr(im_top);
        im_bot = fliplr(im_bot);
        displacementx = -displacementx;
    end
    displacementx_t = markerposition+displacementx;
    if(displacementx_t == 0)
        cols_t = max([cols_top,cols_bot]);
        rows_t = rows_top+displacementy-1;
        image_tot_arr = NaN*zeros(rows_t,cols_t,2);
        image_tot_arr(1:rows_top,1:cols_top,1) = im_top;
        image_tot_arr(rows_t-rows_bot+1:end,1:cols_bot,2) = im_bot;
        image_tot = nanmean(image_tot_arr,3);
        marker = max([0,cols_top-cols_bot]);
    elseif(displacementx_t >0)
        cols_t = max([cols_top,cols_bot+displacementx_t]);
        rows_t = rows_top+displacementy-1;
        image_tot_arr = NaN*zeros(rows_t,cols_t,2);
        image_tot_arr(1:rows_top,1:cols_top,1) = im_top;
        image_tot_arr(rows_t-rows_bot+1:end,displacementx_t:displacementx_t-1+cols_bot,2) = im_bot;
        image_tot = nanmean(image_tot_arr,3);
        marker = max([0,cols_top-(displacementx_t-1+cols_bot)]);
    else
        displacementx_t = -displacementx_t;
        cols_t = max([cols_top+displacementx_t,cols_bot]);
        rows_t = rows_top+displacementy-1;
        image_tot_arr = NaN*zeros(rows_t,cols_t,2);
        image_tot_arr(1:rows_top,displacementx_t:displacementx_t-1+cols_top,1) = im_top;
        image_tot_arr(rows_t-rows_bot+1:end,1:cols_bot,2) = im_bot;
        image_tot = nanmean(image_tot_arr,3);
        marker = max([0,(displacementx_t-1+cols_top)-cols_bot]);
    end
    if(markerside=='r')
        image_tot = fliplr(image_tot);
    end
end