%% A function that calculates the displacement in y direction between two images with a certain region of interest.
% use displacement_y(image_top,image_bottom,maximum_displacementy,max_dispx,RegionOfInterest,waitbar,tot_calc,curr_calc)
% the output is the displacement in pixels in both x and y direction.
% the images must be in doubles, i.e. im2double
% made by J.F.Kooijman 24-9-2013

function [displacementx,displacementy,curr_calc] = displacement_y(im_top,im_bot,max_dispy,max_dispx,roi,hwaitbar,tot_calc,curr_calc)

    % crop out region of non interest
    im_topc = roi_circ(im_top,roi);
    im_botc = roi_circ(im_bot,roi);

    [rows, cols] = size(im_topc);
    corrp = NaN*zeros(rows-1,max_dispx-1);
    corrn = NaN*zeros(rows-1,max_dispx-1);
    corr0 = NaN*zeros(rows-1,1);
    for x = 0:max_dispx
        for k = 1:min(rows-1,max_dispy)
            if (x~=0)
                corrp(k,x) = correlation2d(im_topc(k:rows,x:cols),im_botc(1:rows-k+1,1:cols-x+1));
                corrn(k,x) = correlation2d(im_topc(k:rows,1:cols-x+1),im_botc(1:rows-k+1,x:cols));
            else
                corr0(k) = correlation2d(im_topc(k:rows,:),im_botc(1:rows-k+1,:));
            end
        end
        curr_calc = curr_calc+1;
        waitbar(curr_calc/tot_calc,hwaitbar);
    end
    [maxp,displacementxp]=max(max(corrp));
    [maxn,displacementxn]=max(max(corrn));
    [max0,displacementx0]=max(corr0);
    [~,ddir_m]=max([maxn max0 maxp]);
    if(ddir_m==1)
       displacementx = -displacementxn;
       [~,displacementy]=max(corrn(:,abs(displacementx)));
    elseif(ddir_m==2)
       displacementx = displacementx0;
       [~,displacementy]=max(corr0);
    else
       displacementx = displacementxp;
       [~,displacementy]=max(corrp(:,abs(displacementx)));
    end

    %% paste images together
%     n_rows = displacementy + rows - 1;
%     n_cols = max([cols,cols+displacementx-1,cols-displacementx-1]);
% 
%     Opimg = NaN*zeros(n_rows,n_cols);
%     if(displacementx == 0)
%         Opimg(1:displacementy-1,:) = im_topc(1:displacementy-1,:);
%         Opimg(displacementy:rows,:) = nanmean(cat(3,im_topc(displacementy:rows,:),im_botc(1:rows-displacementy+1,:)),3);
%         Opimg(rows+1:n_rows,:) = im_botc(rows-displacementy+2:end,:);
%     elseif(displacementx >0)
%         Opimg(1:rows,1:end-displacementx+1) = im_topc;
%         Opimg(displacementy:end,displacementx:end) = im_botc;
%         Opimg(displacementy:rows,displacementx:cols) = nanmean(cat(3,im_topc(displacementy:end,displacementx:end),im_botc(1:end-displacementy+1,1:end-displacementx+1)),3);
%     else
%         displacementx = abs(displacementx);
%         Opimg(1:rows,displacementx:end) = im_topc;
%         Opimg(displacementy:end,1:end-displacementx+1) = im_botc;
%         Opimg(displacementy:rows,displacementx:cols) = nanmean(cat(3,im_topc(displacementy:end,1:end-displacementx+1),im_botc(1:end-displacementy+1,displacementx:end)),3);
%         displacementx = -displacementx;
%     end
% 
%     figure;
%     imshow(Opimg)

end