%% A function that pastes two images together in the left to right direction 
% made by J.F.Kooijman 24-9-2013

function image_tot = merge_x(im_left,im_right,displacement)   
        [~, colsl] = size(im_left);
        [rows, colsr] = size(im_right);
        n_cols = max(displacement + colsl - 1,displacement + colsr - 1);% New column of output image.

        image_tot = NaN*zeros(rows,n_cols);
        image_tot(:,1:colsl) = im_left;
        image_tot(:,end-colsr+1:end) = im_right;
        image_tot(:,end-colsr+1:colsl) = nanmean(cat(3,im_left(:,colsl-colsr+displacement:colsl),im_right(:,1:colsr-displacement+1)),3);
            
        %figure;
        %imshow(image_tot);
end