clear all;
close all;
clc;

%% constants
no_x = 49;
no_y = 15;
no_fx = no_x+1;
path='D:Frames\';

%% find roi
im1 = imread('frame19.jpg');
im1 = rgb2gray(im1);   % convert to grayscale
im1 = im2double(im1);  % convert to double 
max_cols = max(im1);
max_rows = max(im1');
ind_non_zero_cols = find(max_cols>0.05);
ind_non_zero_rows = find(max_rows>0.05);
roi.xs = ind_non_zero_cols(1);
roi.ys = ind_non_zero_rows(1);
roi.dx = ind_non_zero_cols(end)-ind_non_zero_cols(1);
roi.dy = ind_non_zero_rows(end)-ind_non_zero_rows(1);
if(roi.dx < roi.dy)
    roi.dy = roi.dx;
else
    roi.dx = roi.dy;
end
roi.xe = roi.xs+roi.dx;
roi.ye = roi.ys+roi.dy;
roi.x = roi.xs:roi.xe;
roi.y = roi.ys:roi.ye;
roi.r = floor(roi.dx/2);

%% find displacements
k = 1; % the counter for the index of the values to correlate
max_disp = roi.dx-10; % the maximum displacement in pixels
h = waitbar(0,'Finding displacements');
for j=no_y-1:-1:0 % defined as the current row, starting from the bottom to top (defined as zero)
    curr_pos = 1;
    y = abs(j-no_y+1); % Represents the row number, starting from 0 at the bottom; 
    if(mod(y,2)==0) % Get the even y's -> place the last image on the far left
         for i = (y+1)*no_fx-1:-1:y*no_fx+1 % i represents the frame number       
            fname{i} = strcat('frame',int2str(i),'.jpg');
            fid = fopen(strcat('frame',int2str(i),'X.txt'));
            Xs = fscanf(fid, '%d', [24 1]);
            fclose(fid);
            fid = fopen(strcat('frame',int2str(i),'Y.txt'));
            Ys = fscanf(fid, '%d', [24 1]);
            fclose(fid);
            X(:,i)=Xs;
            Y(:,i)=Ys;
            if(i~=(y+1)*no_fx-1)
                im_right = imread(fname{i+1});  % loads image 
                im_right = rgb2gray(im_right);   % convert to grayscale
                im_right = im2double(im_right);  % convert to double 
                im_left = imread(fname{i});  % loads image 
                im_left = rgb2gray(im_left);   % convert to grayscale
                im_left = im2double(im_left);  % convert to double 
                displacement(i) = displacement_x(im_right,im_left,roi,max_disp);
                Xk(:,k) = X(:,i);          
                displacementk(k) = displacement(i);
                k = k+1;
            end
            waitbar((floor(i/no_x)*no_x-mod(i,no_x)+no_x)/no_y/no_fx,h);
        end
    end
    if(mod(y,2)~=0) % Get the odd y's -> place the first image on the far left
        for i = y*no_fx+1:(y+1)*no_fx-1 % i represents the frame number
            fname{i} = strcat('frame',int2str(i),'.jpg');
            fid = fopen(strcat('frame',int2str(i),'X.txt'));
            Xs = fscanf(fid, '%d', [24 1]);
            fclose(fid);
            fid = fopen(strcat('frame',int2str(i),'Y.txt'));
            Ys = fscanf(fid, '%d', [24 1]);
            fclose(fid);
            X(:,i)=Xs;
            Y(:,i)=Ys;
            if(i~=y*no_fx+1)
                im_right = imread(fname{i});  % loads image 
                im_right = rgb2gray(im_right);   % convert to grayscale
                im_right = im2double(im_right);  % convert to double 
                im_left = imread(fname{i-1});  % loads image 
                im_left = rgb2gray(im_left);   % convert to grayscale
                im_left = im2double(im_left);  % convert to double 
                displacement(i) = displacement_x(im_right,im_left,roi,max_disp);
                Xk(:,k) = X(:,i);          
                displacementk(k) = displacement(i);
                k = k+1;
            end
            waitbar(i/no_y/no_fx,h);
        end
    end    
end
close(h);

%% plot correlations
for i = 1:24
    figure;
    plot(Xk(i,:),displacementk,'*')
    xlabel('Sensor reading');
    ylabel('Displacement [pixels]'); 
end

%% Preprocessing
corr_ind = find(displacementk>5);
corr_ind = find(displacementk(corr_ind)<170);
new_disp = displacementk(corr_ind);
new_X = Xk(:,corr_ind);
clear Xk displacementk

%% Split validation and fitting data
[cols, rows] = size(Xk);
input = Xk(:,1:floor(0.8*rows));
output = displacementk(1:floor(0.8*rows));
input_valid = Xk(:,floor(0.8*rows)+1:rows);
output_valid = displacementk(floor(0.8*rows)+1:rows);

%% train neural network
net = feedforwardnet(100);
net = train(net,input,output);
output_sim = net(input_valid);

figure;
hold on;
plot(output_valid);
plot(output_sim,'r');
