%% A function that calculates the displacement in x direction between two images with a certain region of interest. 
% use: displacement_x(image_left,image_right,maximum_displacement,RegionOfInterest)
% the output is the displacement in pixels.
% the images must be in doubles, i.e. im2double
% made by J.F.Kooijman 24-9-2013

function displacement = displacement_x(im_left,im_right,max_disp,roi)

    % crop out region of non interest
    im_leftc = roi_circ(im_left,roi);
    im_rightc = roi_circ(im_right,roi);

    [rows, cols] = size(im_leftc); %#ok<ASGLU>
    corr = NaN*zeros(cols-1,1);
    for k = 1:min(cols-1,max_disp)
        corr(k) = correlation2d(im_leftc(:,k:cols),im_rightc(:,1:cols-k+1));
    end
    [~, displacement] = max(corr);% .

    %% paste images together
    % n_cols = displacement + cols - 1;% New column of output image.
    % 
    % 
    % Opimg = NaN*zeros(rows,n_cols);
    % Opimg(:,1:displacement-1) = im_leftc(:,1:displacement-1);
    % Opimg(:,displacement:cols) = nanmean(cat(3,im_leftc(:,displacement:cols),im_rightc(:,1:cols-displacement+1)),3);
    % Opimg(:,cols+1:n_cols) = im_rightc(:,cols-displacement+2:end);
    % 
    % figure;
    % imshow(Opimg)

end