function r = correlation2d(varargin)
    [a,b] = ParseInputs(varargin{:});
    a = a - nanmean(nanmean(a,2));
    b = b - nanmean(nanmean(b,2));
    r = nansum(nansum(a.*b))/sqrt(nansum(nansum(a.*a))*nansum(nansum(b.*b)));
end

function [A,B] = ParseInputs(varargin)

    narginchk(2,2);

    A = varargin{1};
    B = varargin{2};

    validateattributes(A, {'logical' 'numeric'}, {'real'}, mfilename, 'A', 1);
    validateattributes(B, {'logical' 'numeric'}, {'real'}, mfilename, 'B', 2);

    if any(size(A)~=size(B))
        error(message('images:corr2:notSameSize'))
    end

    if (~isa(A,'double'))
        A = double(A);
    end

    if (~isa(B,'double'))
        B = double(B);
    end

end




