#define ledi 0
#define ledo 1
#define DIR_PIN 2
#define STEP_PIN 3      
#define YDIR_PIN 4
#define YSTEP_PIN 5    
#define start_but 9
#define Power 7
#define Sensx 10
#define Sensy 11
#define led 13
#define joystick_X 2
#define joystick_Y 3

int incomingByte;
int i=0;
int state = 0;
int flag = 1;
int xi=0;
int yi=0;
String message="";
String monitor="";
char s;
float micro_sec_delay;
int x_position;
int y_position;

//int check= 0;
int x = 0;
int y = 0;

const int X_THRESHOLD_LOW = 405;
const int X_THRESHOLD_HIGH = 615;    

const int Y_THRESHOLD_LOW = 400;
const int Y_THRESHOLD_HIGH = 610;    

void stepx(int steps, float speed)
{
  byte dir;
  
  if (steps > 0) // If steps are positive
  {
    dir = LOW; // Set direction
  }
  else // If steps are negative
  {
   dir = HIGH; // Set direction
  }

  steps = abs(steps); // Set steps to absolute value
  digitalWrite(DIR_PIN, dir); // Set the direction pin to dir

  micro_sec_delay = 1 / (speed) * 70; // Calculate delay between  step pin toggles

  for (int i = 0; i < steps; i++)
  {
    // Takes all the steps in the specified direction
    digitalWrite(STEP_PIN, HIGH);
    delayMicroseconds(micro_sec_delay);
    digitalWrite(STEP_PIN, LOW);
    delayMicroseconds(micro_sec_delay);
  }
}

void stepy(int steps, float speed)
{
  byte dir;
  if (steps > 0){
    dir = HIGH; // Set direction
  }
  else {
   dir = LOW; // Set direction
  }

  steps = abs(steps); // Set steps to absolute value
  digitalWrite(YDIR_PIN, dir); // Set the direction pin to dir
  micro_sec_delay = 1 / (speed) * 70; // Calculate delay between  step pin toggles

  for (int i = 0; i < steps; i++)
  {
    digitalWrite(YSTEP_PIN, HIGH);
    delayMicroseconds(micro_sec_delay);
    digitalWrite(YSTEP_PIN, LOW);
    delayMicroseconds(micro_sec_delay);
    }
}

void write2pc(int intlong){
  Serial.write(intlong/255);
  delay(1);
  Serial.write(intlong%255);
}


void takeimage(int xi){
  delay(17*5);
  write2pc(xi);
  delay(17*5);
}

void setup() {
   // initialize the digital pin as an output.
  pinMode(STEP_PIN, OUTPUT);
  pinMode(DIR_PIN, OUTPUT);
  pinMode(YSTEP_PIN, OUTPUT);
  pinMode(YDIR_PIN, OUTPUT);
  pinMode(start_but, INPUT);
  pinMode(Sensx, INPUT);
  pinMode(Sensy, INPUT);
  pinMode(ledi, OUTPUT);
  pinMode(ledo, OUTPUT);
  pinMode(led, OUTPUT);
  pinMode(Power,OUTPUT);
  digitalWrite(Power,HIGH);
  digitalWrite(Power,HIGH);
  digitalWrite(ledi,HIGH);
  digitalWrite(ledo,LOW);
  Serial.begin(9600);
  delay(100);
}


void loop() {
    int check=0;
  while(Serial.available())
   {
      delay(20);
      if(Serial.available()){
         s =(char) Serial.read(); // used to read incoming data
         if(s==','){
           check=1;
         }else if (check==0){
           message +=s;
         }else if (check==1){
           monitor +=s;
         }
       }
  }
    x_position = analogRead(joystick_X);
    delay(10);
    y_position = analogRead(joystick_Y);
    if (x_position > X_THRESHOLD_HIGH) {
       stepx(16,0.6*(x_position-X_THRESHOLD_HIGH)/X_THRESHOLD_HIGH);
    } else if (x_position < X_THRESHOLD_LOW) {
       stepx(-16,0.6*(-x_position+X_THRESHOLD_LOW)/X_THRESHOLD_LOW);
    }
    if (y_position > Y_THRESHOLD_HIGH) {
       stepy(-16,0.6*(y_position-Y_THRESHOLD_HIGH)/Y_THRESHOLD_HIGH);
    } else if (y_position < Y_THRESHOLD_LOW) {
       stepy(16,0.6*(-y_position+Y_THRESHOLD_LOW)/Y_THRESHOLD_LOW);      
    }
    x=monitor.toInt();
    if (message == "B" ){
       stepy(x, 0.25);
    }else if(message == "A"){
       stepx(x, 0.25);
    }
    else if (message == "C"){
       while(digitalRead(Sensx)==LOW){
         stepx(8,0.25);
       }
       stepx(-80,2);
       while(digitalRead(Sensy)==LOW){
         stepy(-8,0.25);       
       }
       stepy(80,2);
    }
    else if (message == "T"){
        digitalWrite(led, HIGH);
        yi=0;
        while(yi<25){
          xi=1;
           if((yi % 2) == 0){
            while(xi<=25){
             takeimage(yi*25+xi);
             stepx(-8,0.25);
             xi = xi+1;
            }
          }
            if((yi % 2) != 0){
            while(xi<=25){
             takeimage(yi*25+xi);
             stepx(8,0.25);
             xi = xi+1;
            }
          }
          stepy(8,0.1);
          yi = yi+1;
        }
        write2pc(0);
        digitalWrite(led, LOW);
    }
    if (digitalRead(start_but)==HIGH){
        digitalWrite(led, HIGH);
        yi=0;
        while(yi<4){
          xi=1;
           if((yi % 2) == 0){
            while(xi<=25){
             takeimage(yi*25+xi);
             stepx(-8,0.25);
             xi = xi+1;
            }
          }
            if((yi % 2) != 0){
            while(xi<=25){
             takeimage(yi*25+xi);
             stepx(8,0.25);
             xi = xi+1;
            }
          }
          stepy(8,0.1);
          yi = yi+1;
        }
        write2pc(0);
        digitalWrite(led, LOW);
    }
    message="";
    monitor="";
    check=0;
}
