/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.sprites;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.newcastleigem.biogame.biobricks.BioBrick;
import com.newcastleigem.biogame.sprites.Sprite;
import com.newcastleigem.biogame.utils.LivingConditions;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Bacteria
extends Sprite {
    private ArrayList<BioBrick> installedBricks = new ArrayList();
    private float offsetY = 0.0f;
    private Direction dir = Direction.UP;
    private float happiness = 50.0f;
    private float lastHappinessUpdate = 0.0f;
    private LivingConditions conditions = new LivingConditions(50.0f, 20.0f);
    private final float LB_CONST = 0.001f;
    private final float MSM_CONST = 0.001f;
    private HappinessState hs = HappinessState.HAPPY;

    public Bacteria(Texture t, int w, int h) {
        super(t, w, h, 1, 0);
    }

    public Bacteria(Texture t, int w, int h, int fw, int fh, int numFrames, int fps) {
        super(t, w, h, fw, fh, numFrames, fps);
    }

    public void installBrick(BioBrick b) {
        this.installedBricks.add(b);
        this.idle = false;
        this.changeConditions(b, true);
    }

    public void changeConditions(BioBrick b, boolean installed) {
        LivingConditions bblc = b.getConditions();
        int v = installed ? 1 : -1;
        this.conditions.setLB(this.conditions.getLB() + (float)v * bblc.getLB());
        this.conditions.setMSM(this.conditions.getMSM() + (float)v * bblc.getMSM());
    }

    public Boolean isInstalled(BioBrick b) {
        for (BioBrick temp : this.installedBricks) {
            if (temp.getClass() != b.getClass()) continue;
            return true;
        }
        return false;
    }

    public double getHappiness() {
        return Double.parseDouble(new DecimalFormat("#.##").format(this.happiness));
    }

    public void calculateHappiness(LivingConditions media) {
        float m_lb = media.getLB();
        float m_msm = media.getMSM();
        float b_lb = this.conditions.getLB();
        float b_msm = this.conditions.getMSM();
        this.happiness += (m_lb - b_lb) * 0.001f;
        this.happiness += (m_msm - b_msm) * 0.001f;
        if (this.happiness <= 0.0f) {
            this.hs = HappinessState.DEAD;
        } else if (this.happiness < 25.0f) {
            this.hs = HappinessState.VERY_UNHAPPY;
        } else if (this.happiness < 50.0f) {
            this.hs = HappinessState.UNHAPPY;
        } else if (this.happiness < 75.0f) {
            this.hs = HappinessState.HAPPY;
        } else if (this.happiness < 100.0f) {
            this.hs = HappinessState.VERY_HAPPY;
        }
    }

    public Rectangle boundingRectangle() {
        return new Rectangle((int)this.getX(), (float)((int)this.getY()) - this.offsetY, (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    public TextureRegion getRegion() {
        int y = (int)((float)HappinessState.valueOf(this.hs.toString()).ordinal() * this.getFrameHeight());
        return new TextureRegion(this.getTexture(), 0, y, 175, 85);
    }

    public void floatBac(float delta) {
        if (this.offsetY > 13.0f) {
            this.dir = Direction.DOWN;
        } else if (this.offsetY < -13.0f) {
            this.dir = Direction.UP;
        }
        if (this.dir == Direction.UP) {
            this.moveOffset(0.0f, 15.0f);
        } else {
            this.moveOffset(0.0f, -15.0f);
        }
    }

    private void moveOffset(float x, float y) {
        float newY;
        float speed = 0.0f;
        float multiplier = 0.3f;
        float dx = x;
        float dy = y;
        if (dx != 0.0f && dy != 0.0f) {
            float rx = dy / dx;
            float ry = dx / dy;
            newY = ry * multiplier;
        } else {
            float rx = dx != 0.0f ? dx / Math.abs(dx) : 0.0f;
            float ry = dy != 0.0f ? dy / Math.abs(dy) : 0.0f;
            float newX = rx * multiplier;
            newY = ry * multiplier;
        }
        this.offsetY += newY;
    }

    public void kill() {
        this.idle = false;
        if (this.getY() > -this.getHeight()) {
            this.move(this.getX(), -(this.getHeight() + 20.0f), 2.0f, false);
        }
    }

    public ArrayList<BioBrick> getBricks() {
        return this.installedBricks;
    }

    public boolean removeBioBrick(BioBrick b) {
        if (!this.installedBricks.remove(b)) {
            return false;
        }
        this.changeConditions(b, false);
        return true;
    }

    public void update(float delta, LivingConditions media) {
        BioBrick lastBrick;
        if (this.idle.booleanValue()) {
            this.floatBac(delta);
        }
        if (this.installedBricks.size() > 0 && !(lastBrick = this.installedBricks.get(this.installedBricks.size() - 1)).getAnimated()) {
            lastBrick.update(delta);
        }
        if (this.lastHappinessUpdate >= 1.0f) {
            this.calculateHappiness(media);
            this.lastHappinessUpdate = 0.0f;
        } else {
            this.lastHappinessUpdate += delta;
        }
        if (this.hs == HappinessState.DEAD) {
            this.kill();
        }
    }

    @Override
    public void draw(SpriteBatch batch, float delta) {
        batch.draw(this.getRegion(), this.getX(), this.getY() + this.offsetY, this.getWidth(), this.getHeight());
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static enum HappinessState {
        VERY_HAPPY,
        HAPPY,
        UNHAPPY,
        VERY_UNHAPPY,
        DEAD;

    }
}

