/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.BioGame;
import com.newcastleigem.biogame.biobricks.BioBrick;
import com.newcastleigem.biogame.biobricks.GFP;
import com.newcastleigem.biogame.biobricks.RFP;
import com.newcastleigem.biogame.menus.BioBrickButton;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.menus.ListButton;
import com.newcastleigem.biogame.menus.ListMenu;
import com.newcastleigem.biogame.menus.MediaButton;
import com.newcastleigem.biogame.menus.Menu;
import com.newcastleigem.biogame.sprites.Bacteria;
import com.newcastleigem.biogame.sprites.Sprite;
import com.newcastleigem.biogame.utils.ActionListener;
import com.newcastleigem.biogame.utils.Assets;
import com.newcastleigem.biogame.utils.LivingConditions;
import com.newcastleigem.biogame.utils.TouchState;
import java.util.ArrayList;

public class GameScreen
implements Screen {
    private BioGame g;
    private AssetManager assets;
    private SpriteBatch batch;
    private BitmapFont font;
    private LivingConditions media;
    private Bacteria bac;
    private Sprite bg;
    private TouchState prevTouchState;
    private Menu mainMenu;
    private ListMenu bioBrickMenu;
    private ListMenu bioBrickList;
    private ListMenu mediaMenu;

    public GameScreen(BioGame g) {
        this.g = g;
    }

    @Override
    public void render(float delta) {
        this.update(delta);
        this.draw(delta);
    }

    private void update(float delta) {
        TouchState currentTouchState = TouchState.getTouchState();
        this.bac.update(delta, this.media);
        this.bg.update(delta);
        if (!this.mainMenu.isOpen()) {
            if (currentTouchState.isTouched() && !this.prevTouchState.isTouched()) {
                int touchX = Gdx.input.getX();
                int touchY = Gdx.input.getY();
                if (this.bac.boundingRectangle().contains(touchX, touchY)) {
                    if (this.bac.isIdle().booleanValue()) {
                        this.mainMenu.open();
                    }
                } else if (!this.bac.isInstalled(new GFP()).booleanValue()) {
                    TextureData td = this.bac.getTexture().getTextureData();
                    td.prepare();
                    Pixmap pm = td.consumePixmap();
                    System.out.println("pixel: " + pm.getPixel(20, 20));
                    Color c = new Color();
                    Color.rgba8888ToColor(c, pm.getPixel(20, 20));
                    System.out.println(c);
                }
            }
        } else {
            if (!(this.bioBrickMenu.isOpen() || this.bioBrickList.isOpen() || this.mediaMenu.isOpen())) {
                this.mainMenu.update(delta, currentTouchState, this.prevTouchState);
            }
            if (this.bioBrickMenu.isOpen()) {
                this.bioBrickMenu.update(delta, currentTouchState, this.prevTouchState);
            }
            if (this.bioBrickList.isOpen()) {
                this.bioBrickList.update(delta, currentTouchState, this.prevTouchState);
            }
            if (this.mediaMenu.isOpen()) {
                this.mediaMenu.update(delta, currentTouchState, this.prevTouchState);
            }
        }
        this.prevTouchState = currentTouchState;
    }

    private void draw(float delta) {
        this.batch.begin();
        this.bg.draw(this.batch, delta);
        this.font.draw(this.batch, "Bacterial Happiness: " + this.bac.getHappiness(), 10.0f, Gdx.graphics.getHeight() - 10);
        this.bac.draw(this.batch, delta);
        this.mainMenu.draw(this.batch, delta);
        this.bioBrickMenu.draw(this.batch, delta);
        this.bioBrickList.draw(this.batch, delta);
        this.mediaMenu.draw(this.batch, delta);
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void show() {
        this.font = new BitmapFont();
        this.font.setColor(Color.BLUE);
        this.font.setScale(1.5f);
        this.assets = Assets.getAssets();
        this.batch = new SpriteBatch();
        this.media = new LivingConditions(60.0f, 15.0f);
        this.bac = new Bacteria(this.assets.get("textures/bacteria.png", Texture.class), 175, 85, 175, 85, 1, 15);
        float x = (float)(Gdx.graphics.getWidth() / 2) - this.bac.getWidth() / 2.0f;
        float y = (float)(Gdx.graphics.getHeight() / 2) - this.bac.getHeight() / 2.0f;
        this.bac.setPosition(x, y);
        this.bg = new Sprite(this.assets.get("textures/background.png", Texture.class), Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 480, 800, 4, 5);
        this.prevTouchState = TouchState.getTouchState();
        this.bioBrickList = new ListMenu(250, -1);
        this.initMainMenu();
        this.initBioBrickMenu();
        this.initBioBrickList();
        this.initMediaMenu();
    }

    public void initMainMenu() {
        this.mainMenu = new Menu();
        Button b = new Button(this.assets.get("textures/btns/inst_biobrick.png", Texture.class));
        b.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                GameScreen.this.bioBrickMenu.open();
            }
        });
        this.mainMenu.addButton(b);
        Button b2 = new Button(this.assets.get("textures/btns/uninst_biobrick.png", Texture.class));
        b2.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                GameScreen.this.openBioBrickList();
            }
        });
        this.mainMenu.addButton(b2);
        Button b3 = new Button(this.assets.get("textures/btns/media_btn.png", Texture.class));
        b3.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                GameScreen.this.openMediaMenu();
            }
        });
        this.mainMenu.addButton(b3);
    }

    public void initBioBrickMenu() {
        this.bioBrickMenu = new ListMenu(250, -1);
        BioBrickButton gfpBtn = new BioBrickButton(new GFP());
        gfpBtn.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                GameScreen.this.bac.installBrick(new GFP(GameScreen.this.bac));
                GameScreen.this.bioBrickMenu.close();
                GameScreen.this.mainMenu.close();
            }
        });
        this.bioBrickMenu.addButton(gfpBtn);
        BioBrickButton rfpBtn = new BioBrickButton(new RFP());
        rfpBtn.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                final RFP rfp = new RFP(GameScreen.this.bac);
                GameScreen.this.bac.installBrick(rfp);
                BioBrickButton btn = new BioBrickButton(rfp);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void onClick() {
                        GameScreen.this.bac.removeBioBrick(rfp);
                        GameScreen.this.bioBrickList.close();
                        GameScreen.this.mainMenu.close();
                    }
                });
                GameScreen.this.bioBrickMenu.close();
                GameScreen.this.mainMenu.close();
            }
        });
        this.bioBrickMenu.addButton(rfpBtn);
    }

    public void openBioBrickList() {
        this.bioBrickList.empty();
        this.initBioBrickList();
        this.bioBrickList.open();
    }

    public void initBioBrickList() {
        ArrayList<BioBrick> bricks = this.bac.getBricks();
        if (bricks.size() > 0) {
            for (final BioBrick b : bricks) {
                BioBrickButton btn = new BioBrickButton(b);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void onClick() {
                        GameScreen.this.bac.removeBioBrick(b);
                        GameScreen.this.bioBrickList.close();
                        GameScreen.this.mainMenu.close();
                    }
                });
                this.bioBrickList.addButton(btn);
            }
        } else {
            ListButton btn = new ListButton("No BioBricks installed", 450);
            btn.addActionListener(new ActionListener(){

                @Override
                public void onClick() {
                    GameScreen.this.bioBrickList.close();
                }
            });
            this.bioBrickList.addButton(btn);
        }
    }

    public void openMediaMenu() {
        this.mediaMenu.empty();
        this.initMediaMenu();
        this.mediaMenu.open();
    }

    public void initMediaMenu() {
        this.mediaMenu = new ListMenu(250, -1);
        MediaButton lb = new MediaButton("LB", this.media.getLB());
        lb.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                Gdx.input.setOnscreenKeyboardVisible(true);
                Input.TextInputListener listener = new Input.TextInputListener(){

                    @Override
                    public void input(String text) {
                        float d = GameScreen.this.parseNumber(text);
                        if (d > 0.0f) {
                            GameScreen.this.media.setLB(d);
                        }
                    }

                    @Override
                    public void canceled() {
                        GameScreen.this.mainMenu.close();
                    }
                };
                Gdx.input.getTextInput(listener, "Dialog Title", String.valueOf(GameScreen.this.media.getLB()));
            }
        });
        MediaButton msm = new MediaButton("MSM", this.media.getMSM());
        msm.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                Gdx.input.setOnscreenKeyboardVisible(true);
                Input.TextInputListener listener = new Input.TextInputListener(){

                    @Override
                    public void input(String text) {
                        float d = GameScreen.this.parseNumber(text);
                        if (d > 0.0f) {
                            GameScreen.this.media.setMSM(d);
                        }
                    }

                    @Override
                    public void canceled() {
                        GameScreen.this.mainMenu.close();
                    }
                };
                Gdx.input.getTextInput(listener, "Dialog Title", String.valueOf(GameScreen.this.media.getMSM()));
            }
        });
        MediaButton nb = new MediaButton("NB", this.media.getNB());
        nb.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                Gdx.input.setOnscreenKeyboardVisible(true);
                Input.TextInputListener listener = new Input.TextInputListener(){

                    @Override
                    public void input(String text) {
                        float d = GameScreen.this.parseNumber(text);
                        if (d > 0.0f) {
                            GameScreen.this.media.setNB(d);
                        }
                    }

                    @Override
                    public void canceled() {
                        GameScreen.this.mainMenu.close();
                    }
                };
                Gdx.input.getTextInput(listener, "Dialog Title", String.valueOf(GameScreen.this.media.getNB()));
            }
        });
        this.mediaMenu.addButton(lb);
        this.mediaMenu.addButton(msm);
        this.mediaMenu.addButton(nb);
    }

    public float parseNumber(String s) {
        float d;
        try {
            d = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            d = -1.0f;
        }
        return d;
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

