/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.biobricks;

import com.badlogic.gdx.Gdx;
import com.newcastleigem.biogame.biobricks.BioBrick;
import com.newcastleigem.biogame.sprites.Bacteria;
import com.newcastleigem.biogame.utils.LivingConditions;

public class RFP
implements BioBrick {
    private State state;
    private boolean animated;
    private Bacteria b;
    private LivingConditions conditions;

    public RFP(Bacteria b) {
        this.b = b;
        this.animated = false;
        this.state = State.EXPAND;
        this.conditions = new LivingConditions(1000.0f, 3330.0f);
    }

    public RFP() {
    }

    @Override
    public void update(float delta) {
        if (this.state == State.EXPAND) {
            System.out.println((int)this.b.getFrameWidth() + 100);
            this.b.resizeByWidth((int)this.b.getFrameWidth() + 100, delta, false);
            if (this.getBacteria().getWidth() > this.b.getFrameWidth() + 99.0f) {
                this.state = State.CONTRACT;
            }
        } else if (this.state == State.CONTRACT) {
            this.b.resizeByWidth((int)this.b.getFrameWidth() - 2, delta, false);
            if (this.getBacteria().getWidth() < this.b.getFrameWidth() + 1.0f) {
                this.state = State.FINAL;
                this.setAnimated(true);
                this.getBacteria().setIdle(true);
            }
        }
    }

    @Override
    public boolean getAnimated() {
        return this.animated;
    }

    @Override
    public void setAnimated(Boolean b) {
        this.animated = b;
    }

    @Override
    public int getMaxWidth() {
        return Gdx.graphics.getWidth() - 20;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
    }

    @Override
    public Bacteria getBacteria() {
        return this.b;
    }

    @Override
    public LivingConditions getConditions() {
        return this.conditions;
    }

    @Override
    public String getDescription() {
        return "This BioBrick will make your Bacteria fluoresce red";
    }

    @Override
    public String getPartNum() {
        return "blah";
    }

    @Override
    public String getName() {
        return "RFP";
    }

    private static enum State {
        EXPAND,
        CONTRACT,
        FINAL;

    }
}

