/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetJavaImpl {
    private final ExecutorService executorService = Executors.newCachedThreadPool();

    public void sendHttpRequest(final Net.HttpRequest httpRequest, final Net.HttpResponseListener httpResponseListener) {
        if (httpRequest.getUrl() == null) {
            httpResponseListener.failed(new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            URL url;
            String method = httpRequest.getMethod();
            if (method.equalsIgnoreCase("GET")) {
                String queryString = "";
                String value = httpRequest.getContent();
                if (value != null && !"".equals(value)) {
                    queryString = "?" + value;
                }
                url = new URL(httpRequest.getUrl() + queryString);
            } else {
                url = new URL(httpRequest.getUrl());
            }
            final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            final boolean doingOutPut = method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT");
            connection.setDoOutput(doingOutPut);
            connection.setDoInput(true);
            connection.setRequestMethod(method);
            Map<String, String> headers = httpRequest.getHeaders();
            Set<String> keySet = headers.keySet();
            for (String name : keySet) {
                connection.addRequestProperty(name, headers.get(name));
            }
            connection.setConnectTimeout(httpRequest.getTimeOut());
            connection.setReadTimeout(httpRequest.getTimeOut());
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (doingOutPut) {
                            String contentAsString = httpRequest.getContent();
                            InputStream contentAsStream = httpRequest.getContentStream();
                            OutputStream outputStream = connection.getOutputStream();
                            if (contentAsString != null) {
                                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                                writer.write(contentAsString);
                                writer.flush();
                                writer.close();
                            } else if (contentAsStream != null) {
                                StreamUtils.copyStream(contentAsStream, outputStream);
                                outputStream.flush();
                                outputStream.close();
                            }
                        }
                        connection.connect();
                        final HttpClientResponse clientResponse = new HttpClientResponse(connection);
                        Gdx.app.postRunnable(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    httpResponseListener.handleHttpResponse(clientResponse);
                                }
                                finally {
                                    connection.disconnect();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                connection.disconnect();
                                httpResponseListener.failed(e);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            httpResponseListener.failed(e);
            return;
        }
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private HttpURLConnection connection;
        private HttpStatus status;
        private InputStream inputStream;

        public HttpClientResponse(HttpURLConnection connection) throws IOException {
            this.connection = connection;
            try {
                this.inputStream = connection.getInputStream();
            }
            catch (IOException e) {
                this.inputStream = connection.getErrorStream();
            }
            try {
                this.status = new HttpStatus(connection.getResponseCode());
            }
            catch (IOException e) {
                this.status = new HttpStatus(-1);
            }
        }

        @Override
        public byte[] getResult() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            try {
                int nRead;
                while ((nRead = this.inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
            }
            catch (IOException e) {
                return new byte[0];
            }
            return buffer.toByteArray();
        }

        @Override
        public String getResultAsString() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = "";
            try {
                String tmp;
                while ((tmp = reader.readLine()) != null) {
                    line = line + tmp;
                }
                reader.close();
                return line;
            }
            catch (IOException e) {
                return "";
            }
        }

        @Override
        public InputStream getResultAsStream() {
            return this.inputStream;
        }

        @Override
        public HttpStatus getStatus() {
            return this.status;
        }
    }
}

