/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;

public abstract class BaseShader
implements Shader {
    private final Array<UniformEntry> uniformEntries = new Array();
    private int[] uniformLocations;
    private ShaderProgram program;

    protected int registerUniform(UniformEntry entry) {
        if (this.program != null) {
            throw new GdxRuntimeException("Cannot register uniforms after initialization");
        }
        this.uniformEntries.add(entry);
        return this.uniformEntries.size - 1;
    }

    protected int registerUniform(String name, long material, long attribute, long userFlag) {
        UniformEntry entry = UniformEntry.pool.obtain();
        entry.name = name;
        entry.material = material;
        entry.attribute = attribute;
        entry.userFlag = userFlag;
        return this.registerUniform(entry);
    }

    protected int registerUniform(String name, long material, long attribute) {
        return this.registerUniform(name, material, attribute, 0L);
    }

    protected int registerUniform(String name, long material) {
        return this.registerUniform(name, material, 0L, 0L);
    }

    protected int registerUniform(String name) {
        return this.registerUniform(name, 0L, 0L, 0L);
    }

    protected void init(ShaderProgram program, long material, long attributes, long userMask) {
        if (this.program != null) {
            throw new GdxRuntimeException("Already initialized");
        }
        if (!program.isCompiled()) {
            throw new GdxRuntimeException(program.getLog());
        }
        this.program = program;
        this.uniformLocations = new int[this.uniformEntries.size];
        for (int i = 0; i < this.uniformLocations.length; ++i) {
            UniformEntry entry = this.uniformEntries.get(i);
            this.uniformLocations[i] = (material & entry.material) == entry.material && (attributes & entry.attribute) == entry.attribute && (userMask & entry.userFlag) == entry.userFlag ? program.fetchUniformLocation(entry.name, false) : -1;
        }
        UniformEntry.pool.freeAll(this.uniformEntries);
        this.uniformEntries.clear();
    }

    @Override
    public void dispose() {
        this.program = null;
        this.uniformLocations = null;
    }

    protected boolean hasUniform(int what) {
        return this.uniformLocations[what] >= 0;
    }

    protected int loc(int what) {
        return this.uniformLocations[what];
    }

    protected boolean set(int what, Matrix4 value) {
        if (this.uniformLocations[what] < 0) {
            return false;
        }
        this.program.setUniformMatrix(this.uniformLocations[what], value);
        return true;
    }

    protected boolean set(int what, Matrix3 value) {
        if (this.uniformLocations[what] < 0) {
            return false;
        }
        this.program.setUniformMatrix(this.uniformLocations[what], value);
        return true;
    }

    protected boolean set(int what, Vector3 value) {
        if (this.uniformLocations[what] < 0) {
            return false;
        }
        this.program.setUniformf(this.uniformLocations[what], value);
        return true;
    }

    protected boolean set(int what, Color value) {
        if (this.uniformLocations[what] < 0) {
            return false;
        }
        this.program.setUniformf(this.uniformLocations[what], value);
        return true;
    }

    protected boolean set(int what, float value) {
        if (this.uniformLocations[what] < 0) {
            return false;
        }
        this.program.setUniformf(this.uniformLocations[what], value);
        return true;
    }

    private static class UniformEntry {
        public String name;
        public long material;
        public long attribute;
        public long userFlag;
        public static final Pool<UniformEntry> pool = new Pool<UniformEntry>(){

            @Override
            protected UniformEntry newObject() {
                return new UniformEntry();
            }
        };
    }
}

