/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.graphics.g3d.materials.Material;

public class BlendingAttribute
extends Material.Attribute {
    public static final String Alias = "blended";
    public static final long Type = BlendingAttribute.register("blended");
    public int sourceFunction;
    public int destFunction;
    public float opacity = 1.0f;

    public static final boolean is(long mask) {
        return (mask & Type) == mask;
    }

    public BlendingAttribute() {
        this(null);
    }

    public BlendingAttribute(int sourceFunc, int destFunc, float opacity) {
        super(Type);
        this.sourceFunction = sourceFunc;
        this.destFunction = destFunc;
        this.opacity = opacity;
    }

    public BlendingAttribute(int sourceFunc, int destFunc) {
        this(sourceFunc, destFunc, 1.0f);
    }

    public BlendingAttribute(BlendingAttribute copyFrom) {
        this(copyFrom == null ? 770 : copyFrom.sourceFunction, copyFrom == null ? 771 : copyFrom.destFunction, copyFrom == null ? 1.0f : copyFrom.opacity);
    }

    @Override
    public BlendingAttribute copy() {
        return new BlendingAttribute(this);
    }

    @Override
    protected boolean equals(Material.Attribute other) {
        return ((BlendingAttribute)other).sourceFunction == this.sourceFunction && ((BlendingAttribute)other).destFunction == this.destFunction;
    }
}

