/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.sprites;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class Sprite {
    private Texture texture;
    private final int NUM_FRAMES;
    private final int FRAME_W;
    private final int FRAME_H;
    private float width;
    private float height;
    private Vector2 pos;
    protected Boolean idle;
    protected int frameNum;
    private float frameLength;
    private Vector2 framePos;
    private float lastUpdate;

    public Sprite(Texture t, int w, int h, int numFrames, int fps) {
        this.texture = t;
        this.NUM_FRAMES = numFrames;
        this.width = w;
        this.height = h;
        this.FRAME_W = w;
        this.FRAME_H = h;
        this.pos = new Vector2(0.0f, 0.0f);
        this.frameNum = 0;
        this.idle = true;
        this.framePos = new Vector2(0.0f, 0.0f);
        this.frameLength = fps != 0 ? 1.0f / (float)fps : 0.0f;
        this.lastUpdate = 0.0f;
    }

    public Sprite(Texture t, int w, int h, int fw, int fh, int numFrames, int fps) {
        this.texture = t;
        this.NUM_FRAMES = numFrames;
        this.width = w;
        this.height = h;
        this.FRAME_W = fw;
        this.FRAME_H = fh;
        this.pos = new Vector2(0.0f, 0.0f);
        this.frameNum = 0;
        float frameX = fw > w ? (fw - w) / 2 : fw;
        float frameY = fh > h ? (fh - h) / 2 : fh;
        this.framePos = new Vector2(frameX, frameY);
        this.idle = true;
        this.frameLength = fps != 0 ? 1.0f / (float)fps : 0.0f;
        this.lastUpdate = 0.0f;
    }

    public Sprite(Texture t) {
        this.texture = t;
        this.NUM_FRAMES = 1;
        this.FRAME_W = t.getWidth();
        this.FRAME_H = t.getHeight();
        this.width = t.getWidth();
        this.height = t.getHeight();
        this.pos = new Vector2(0.0f, 0.0f);
        this.framePos = new Vector2(0.0f, 0.0f);
        this.frameLength = 0.0f;
        this.idle = true;
        this.lastUpdate = 0.0f;
    }

    public void draw(SpriteBatch batch, float delta) {
        batch.draw(this.getRegion(), this.pos.x, this.pos.y, this.width, this.height);
    }

    public void update(float delta) {
        if (this.frameLength > 0.0f) {
            if (this.lastUpdate > this.frameLength) {
                this.frameNum = (this.frameNum + 1) % this.getNumFrames();
                this.lastUpdate = 0.0f;
            } else {
                this.lastUpdate += delta;
            }
        }
    }

    protected Rectangle boundingRectangle(int w, int h) {
        float x = this.width / 2.0f - (float)(w / 2) + this.pos.x;
        float y = this.height / 2.0f - (float)(h / 2) + this.pos.y;
        return new Rectangle((int)x, (int)y, w, h);
    }

    public Boolean isIdle() {
        return this.idle;
    }

    public void setIdle(Boolean i) {
        this.idle = i;
    }

    public int getNumFrames() {
        return this.NUM_FRAMES;
    }

    public void setFrameNum(int i) {
        this.frameNum = i;
    }

    public TextureRegion getRegion() {
        return new TextureRegion(this.texture, this.frameNum * this.FRAME_W, 0, this.FRAME_W, this.FRAME_H);
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setPosition(float x, float y) {
        this.pos = new Vector2(x, y);
    }

    public void centerX() {
        this.pos = new Vector2((float)(Gdx.graphics.getWidth() / 2) - this.getWidth() / 2.0f, this.pos.y);
    }

    public void centerY() {
        this.pos = new Vector2(this.pos.x, (float)(Gdx.graphics.getHeight() / 2) - this.getHeight() / 2.0f);
    }

    public void center() {
        this.centerX();
        this.centerY();
    }

    public float getX() {
        return this.pos.x;
    }

    public float getY() {
        return this.pos.y;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setFrameSize(int w, int h) {
    }

    public void setSizeViaWidth(float w) {
        float m = w / this.width;
        this.width = w;
        this.height *= m;
    }

    public void setSizeViaHeight(int h) {
        float m = (float)h / this.height;
        this.height = h;
        this.width = (int)(this.width * m);
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getFrameWidth() {
        return this.FRAME_W;
    }

    public float getFrameHeight() {
        return this.FRAME_H;
    }

    public void move(float x, float y, float s, boolean ease) {
        float newY;
        float newX;
        float multiplier = s;
        float dx = x - this.pos.x;
        float dy = y - this.pos.y;
        if (dx != 0.0f && dy != 0.0f) {
            float rx = dy / dx;
            float ry = dx / dy;
            newX = this.pos.x + rx * multiplier;
            newY = this.pos.y + ry * multiplier;
        } else if (ease) {
            float rx = dx;
            float ry = dy;
            newX = this.pos.x + rx * multiplier / 5.0f;
            newY = this.pos.y + ry * multiplier / 5.0f;
        } else {
            float rx = dx != 0.0f ? dx / Math.abs(dx) : 0.0f;
            float ry = dy != 0.0f ? dy / Math.abs(dy) : 0.0f;
            newX = this.pos.x + rx * multiplier;
            newY = this.pos.y + ry * multiplier;
        }
        this.pos.x = newX;
        this.pos.y = newY;
    }

    public void resizeByWidth(int w, float d, boolean ease) {
        float multiplier = 4.0f;
        float dw = (float)w - this.getWidth();
        if (dw != 0.0f) {
            float newW;
            if (ease) {
                newW = this.getWidth() + dw * multiplier / 5.0f;
            } else {
                float rw = dw / Math.abs(dw);
                newW = this.getWidth() + rw * multiplier;
            }
            float oldW = this.getWidth();
            float oldH = this.getHeight();
            this.setSizeViaWidth(newW);
            newW = this.getWidth();
            float newH = this.getHeight();
            float cw = (newW - oldW) / 2.0f;
            float ch = (newH - oldH) / 2.0f;
            this.setPosition(this.getX() - cw, this.getY() - ch);
        }
    }

    protected float getLastUpdate() {
        return this.lastUpdate;
    }

    protected void setLastUpdate(float delta) {
        this.lastUpdate = delta;
    }

    public static enum TypeOfSprite {
        STATIC,
        ANIMATED;

    }
}

