/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.BioGame;
import com.newcastleigem.biogame.sprites.Sprite;
import com.newcastleigem.biogame.sprites.TiledSprite;
import com.newcastleigem.biogame.utils.Assets;

public class LoadingScreen
implements Screen {
    private AssetManager assets;
    private BitmapFont font;
    private String loadText;
    private BioGame g;
    private SpriteBatch batch;
    private TiledSprite splash;
    private Sprite loadingBox;
    private Sprite bluePixel;
    private Sprite logo;
    private double progress;
    private double barWidth;

    public LoadingScreen(BioGame g) {
        this.g = g;
    }

    @Override
    public void render(float delta) {
        this.update(delta);
        this.draw(delta);
    }

    public void update(float delta) {
        this.assets.update();
        this.progress = this.assets.getProgress();
        this.barWidth = (double)(this.loadingBox.getRegion().getRegionWidth() - 8) * this.progress;
        int prg = (int)this.progress;
        this.loadText = "Loading ~ " + prg + "%";
    }

    public void draw(float delta) {
        this.batch.begin();
        this.splash.draw(this.batch, delta);
        this.logo.draw(this.batch, delta);
        this.batch.draw(this.bluePixel.getTexture(), this.loadingBox.getX() + 4.0f, this.loadingBox.getY() + 4.0f, (float)((int)this.barWidth), (float)(this.loadingBox.getRegion().getRegionHeight() - 8));
        this.loadingBox.draw(this.batch, delta);
        this.font.drawMultiLine(this.batch, "Loading" + this.loadText, Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2 + this.loadingBox.getRegion().getRegionHeight(), 0.0f, BitmapFont.HAlignment.CENTER);
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void show() {
        this.splash = new TiledSprite(new Texture("textures/splash_bg.png"), 150, 111);
        this.loadingBox = new Sprite(new Texture("textures/loading_box.png"), 208, 38, 0, 0);
        this.loadingBox.center();
        this.bluePixel = new Sprite(new Texture("textures/blue_pxl.png"));
        Texture t = new Texture("logos/logo.png");
        this.logo = new Sprite(t);
        this.logo.setSizeViaWidth(Gdx.graphics.getWidth() - 30);
        this.logo.centerX();
        this.logo.setPosition(this.logo.getX(), this.loadingBox.getY() + this.loadingBox.getHeight() + (this.loadingBox.getY() + this.loadingBox.getHeight()) / 2.0f - this.logo.getHeight() / 2.0f);
        this.loadText = "";
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
        this.assets = Assets.getAssets();
        this.font.setColor(Color.BLUE);
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

