/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.BioGame;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.menus.ButtonGroup;
import com.newcastleigem.biogame.screens.GameScreen;
import com.newcastleigem.biogame.sprites.TiledSprite;
import com.newcastleigem.biogame.utils.ActionListener;
import com.newcastleigem.biogame.utils.Assets;
import com.newcastleigem.biogame.utils.TouchState;

public class HomeScreen
implements Screen {
    private BioGame g;
    private AssetManager am;
    private BitmapFont font;
    private ButtonGroup btns;
    private Button playBtn;
    private Button wikiBtn;
    private SpriteBatch batch;
    private TouchState prevTouchState;
    private TiledSprite bg;
    private String welcome;

    public HomeScreen(BioGame g) {
        this.g = g;
    }

    @Override
    public void render(float delta) {
        this.update(delta);
        this.draw(delta);
    }

    public void update(float delta) {
        TouchState curTouchState = TouchState.getTouchState();
        this.btns.update(delta, curTouchState, this.prevTouchState);
        this.prevTouchState = curTouchState;
    }

    public void draw(float delta) {
        this.batch.begin();
        this.bg.draw(this.batch, delta);
        this.font.drawMultiLine(this.batch, this.welcome, 10.0f, Gdx.graphics.getHeight() - 10, Gdx.graphics.getWidth() - 20, BitmapFont.HAlignment.CENTER);
        this.btns.draw(this.batch, delta);
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void show() {
        this.welcome = "Hello!!\nAnd welcome to L-former! The L-form creation game from BareCillus.\nThe aim is to grow and nurture you L-form Bacterium!w";
        this.am = Assets.getAssets();
        this.btns = new ButtonGroup();
        this.font = new BitmapFont();
        this.font.setScale(1.5f);
        this.font.setColor(Color.BLUE);
        this.batch = new SpriteBatch();
        this.bg = new TiledSprite(new Texture("textures/splash_bg.png"), 150, 111);
        this.playBtn = new Button(this.am.get("textures/btns/play_btn.png", Texture.class));
        this.btns.addButton(this.playBtn);
        this.playBtn.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                HomeScreen.this.g.setScreen(new GameScreen(HomeScreen.this.g));
            }
        });
        this.wikiBtn = new Button(this.am.get("textures/btns/wiki_btn.png", Texture.class));
        this.btns.addButton(this.wikiBtn);
        this.wikiBtn.addActionListener(new ActionListener(){

            @Override
            public void onClick() {
                HomeScreen.this.g.getDependencies().openURL("http://2013.igem.org/Team:Newcastle/Outreach/BioGame#Guide");
            }
        });
        this.prevTouchState = TouchState.getTouchState();
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

