/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.menus.ButtonGroup;
import com.newcastleigem.biogame.utils.Assets;
import com.newcastleigem.biogame.utils.TouchState;

public class Menu {
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private Texture pxl = Assets.getAssets().get("textures/blue_pxl.png", Texture.class);
    private Texture lPxl = Assets.getAssets().get("textures/l_blue_pxl.png", Texture.class);
    private ButtonGroup buttons = new ButtonGroup();
    private boolean isClicked = false;
    private boolean open = false;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setWidth(int w) {
        this.width = w;
    }

    protected void setHeight(int h) {
        this.height = h;
    }

    public Rectangle boundingRectangle() {
        return new Rectangle(this.x, this.y, this.getWidth(), this.getHeight());
    }

    public void update(float delta, TouchState cts, TouchState pts) {
        if (this.open) {
            this.buttons.update(delta, cts, pts);
            this.clickClose(delta, cts, pts);
        }
    }

    public void clickClose(float delta, TouchState cts, TouchState pts) {
        if (!this.isClicked && !pts.isTouched() && cts.isTouched() && !this.boundingRectangle().contains(cts.getTouchPoint())) {
            this.isClicked = true;
        } else if (this.isClicked && this.boundingRectangle().contains(cts.getTouchPoint())) {
            if (!cts.isTouched()) {
                this.isClicked = false;
            }
        } else if (this.isClicked && !this.boundingRectangle().contains(cts.getTouchPoint()) && !cts.isTouched()) {
            this.isClicked = false;
            this.close();
        }
    }

    public void draw(SpriteBatch batch, float delta) {
        if (this.open) {
            batch.draw(this.lPxl, (float)this.x, (float)this.y, (float)this.width, (float)this.height);
            batch.draw(this.pxl, (float)(this.x + this.buttons.getPadding() / 2), (float)(this.y + this.buttons.getPadding() / 2), (float)(this.width - this.buttons.getPadding()), (float)(this.height - this.buttons.getPadding()));
            this.buttons.draw(batch, delta);
        }
    }

    public void open() {
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public void addButton(Button b) {
        this.buttons.addButton(b);
        if (this.buttons.maxWidth() + (float)(this.buttons.getPadding() * 2) > (float)this.width) {
            this.width = (int)this.buttons.maxWidth();
            this.x = Gdx.graphics.getWidth() / 2 - this.width / 2;
        }
        this.height = (int)this.buttons.getHeight() + this.buttons.getPadding() * 3;
        this.y = Gdx.graphics.getHeight() / 2 - this.height / 2;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }
}

