/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.menus.ButtonGroup;
import com.newcastleigem.biogame.menus.Menu;
import com.newcastleigem.biogame.utils.TouchState;

public class ListMenu
extends Menu {
    private final int MAX_WIDTH = Gdx.graphics.getWidth() - 10;
    private final int MAX_HEIGHT = Gdx.graphics.getHeight() - 10;
    private ButtonGroup btns;

    public ListMenu(int w, int h) {
        int width = w < this.MAX_WIDTH && w > 0 ? w : this.MAX_WIDTH;
        int height = h < this.MAX_HEIGHT && h > 0 ? h : this.MAX_HEIGHT;
        this.setWidth(width);
        this.setHeight(height);
        int x = Gdx.graphics.getWidth() / 2 - width / 2;
        int y = Gdx.graphics.getHeight() / 2 - height / 2;
        this.setX(x);
        this.setY(y);
        this.btns = new ButtonGroup();
        this.btns.setX(x);
        this.btns.setY(y);
    }

    @Override
    public void update(float delta, TouchState cts, TouchState pts) {
        if (this.isOpen()) {
            this.btns.update(delta, cts, pts);
            this.clickClose(delta, cts, pts);
        }
    }

    @Override
    public void draw(SpriteBatch batch, float delta) {
        if (this.isOpen()) {
            this.btns.draw(batch, delta);
        }
    }

    @Override
    public void addButton(Button b) {
        float temp;
        this.btns.addButton(b);
        if (b.getWidth() > (float)this.MAX_WIDTH) {
            b.setWidth(this.MAX_WIDTH);
        }
        if ((temp = this.btns.getHeight()) < (float)this.MAX_HEIGHT) {
            this.setHeight((int)temp);
        }
    }

    public void empty() {
        this.btns.empty();
    }
}

