/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.utils.Assets;

public class ListButton
extends Button {
    private AssetManager am = Assets.getAssets();
    private Texture bodyPixel;
    private Texture borderPixel = this.am.get("textures/l_blue_pxl.png", Texture.class);
    private BitmapFont font;
    private String text;

    public ListButton(String t, int w) {
        this.bodyPixel = this.am.get("textures/blue_pxl.png", Texture.class);
        this.font = new BitmapFont();
        this.font.setColor(Color.WHITE);
        this.font.setScale(2.0f);
        this.setWidth(w);
        this.setHeight(this.font.getLineHeight() + 15.0f);
        this.setHitWidth(w);
        this.setHitHeight((int)this.font.getLineHeight());
        this.text = t;
        this.setHitTestModifiers(0, -5);
    }

    @Override
    public void draw(SpriteBatch batch, float delta) {
        batch.draw(this.borderPixel, this.getX() - 5.0f, this.getY(), this.getWidth(), this.getHeight());
        batch.draw(this.bodyPixel, this.getX(), this.getY() + 5.0f, this.getWidth() - 10.0f, this.getHeight() - 10.0f);
        this.drawText(batch, delta);
    }

    public BitmapFont getFont() {
        return this.font;
    }

    @Override
    public void viewState() {
        this.bodyPixel = this.getState() == Button.State.OVER ? this.am.get("textures/l_blue_pxl.png", Texture.class) : this.am.get("textures/blue_pxl.png", Texture.class);
    }

    public void drawText(SpriteBatch batch, float delta) {
        this.font.drawWrapped(batch, this.text, this.getX(), this.getY() + this.getHeight() - 10.0f, this.getWidth() - 20.0f, BitmapFont.HAlignment.CENTER);
    }

    public void veiwState() {
    }
}

