/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.newcastleigem.biogame.menus.Button;
import com.newcastleigem.biogame.utils.TouchState;
import java.util.LinkedList;

public class ButtonGroup
extends Actor {
    private LinkedList<Button> btns = new LinkedList();
    private int padding;
    private float maxWidth;
    private float height;
    private boolean centeredX;
    private boolean centeredY;

    public ButtonGroup() {
        this.setStage(new Stage());
        this.maxWidth = 0.0f;
        this.height = 0.0f;
        this.padding = 20;
        this.centeredX = true;
        this.centeredY = true;
    }

    public void addButton(Button btn) {
        this.btns.add(btn);
        this.height += btn.getHeight() + (float)this.padding;
        if (btn.getWidth() > this.maxWidth) {
            this.maxWidth = btn.getWidth();
        }
        if (this.centeredX) {
            float x = (float)(Gdx.graphics.getWidth() / 2) - this.maxWidth / 2.0f;
            this.setX(x);
        }
        if (this.centeredY) {
            float y = (float)(Gdx.graphics.getHeight() / 2) - this.height / 2.0f + (float)(this.padding / 2);
            this.setY(y);
        }
        int count = 1;
        for (Button b : this.btns) {
            int multiplier = this.btns.size() - count;
            float y = this.getY() + 5.0f + b.getHeight() * (float)multiplier;
            float x = this.getX() + 5.0f;
            b.setY(y);
            b.setX(x);
            ++count;
        }
    }

    public void update(float delta, TouchState cts, TouchState pts) {
        for (Button b : this.btns) {
            b.update(delta, cts, pts);
        }
    }

    @Override
    public void draw(SpriteBatch batch, float delta) {
        for (Button b : this.btns) {
            b.draw(batch, delta);
        }
    }

    public int getNum() {
        return this.btns.size();
    }

    public float maxWidth() {
        return this.maxWidth;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public int getPadding() {
        return this.padding;
    }

    public void empty() {
        this.btns.clear();
        this.height = 0.0f;
        this.setY(Gdx.graphics.getHeight() / 2);
    }
}

