/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.newcastleigem.biogame.utils.ActionListener;
import com.newcastleigem.biogame.utils.TouchState;

public class Button
extends Actor {
    private BitmapFont font;
    private ActionListener e;
    private Texture texture;
    private int frameNum;
    private final int FRAME_W;
    private final int FRAME_H;
    private int hModifier;
    private int vModifier;
    private int hitWidth;
    private int hitHeight;
    private boolean isClicked;
    private State state = State.OUT;

    public Button() {
        this.FRAME_W = 0;
        this.FRAME_H = 0;
    }

    public Button(Texture t) {
        this.texture = t;
        this.font = new BitmapFont();
        this.font.setColor(Color.WHITE);
        this.setWidth(400.0f);
        this.setHeight(100.0f);
        this.FRAME_W = (int)this.getWidth();
        this.FRAME_H = (int)this.getHeight();
        this.hitWidth = 328;
        this.hitHeight = 80;
        this.vModifier = 35;
        this.hModifier = 16;
        this.setX(0.0f);
        this.setY(0.0f);
    }

    public Rectangle boundingRectangle() {
        return new Rectangle(this.getX() + (float)this.vModifier, this.getY() + (float)this.hModifier, this.hitWidth, this.hitHeight);
    }

    public void update(float delta, TouchState cts, TouchState pts) {
        if (this.e != null) {
            if (!this.isClicked && !pts.isTouched() && cts.isTouched() && this.boundingRectangle().contains(cts.getTouchPoint())) {
                this.state = State.OVER;
                this.isClicked = true;
            } else if (this.isClicked && !this.boundingRectangle().contains(cts.getTouchPoint())) {
                this.state = State.OUT;
                if (!cts.isTouched()) {
                    this.isClicked = false;
                }
            } else if (this.isClicked && this.boundingRectangle().contains(cts.getTouchPoint())) {
                this.state = State.OVER;
                if (!cts.isTouched()) {
                    this.state = State.OUT;
                    this.isClicked = false;
                    this.e.onClick();
                }
            }
        }
        this.viewState();
    }

    @Override
    public void draw(SpriteBatch batch, float delta) {
        batch.draw(this.getRegion(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setFrameNum(int i) {
        this.frameNum = i;
    }

    public void viewState() {
        if (this.state == State.OVER) {
            this.setFrameNum(1);
        } else {
            this.setFrameNum(0);
        }
    }

    public void setState(State s) {
        this.state = s;
    }

    public State getState() {
        return this.state;
    }

    public TextureRegion getRegion() {
        return new TextureRegion(this.texture, this.frameNum * this.FRAME_W, 0, this.FRAME_W, this.FRAME_H);
    }

    public void addActionListener(ActionListener actionListener) {
        this.e = actionListener;
    }

    public void centerX() {
        this.setX((float)(Gdx.graphics.getWidth() / 2) - this.getWidth() / 2.0f);
    }

    public void centerY() {
        this.setY((float)(Gdx.graphics.getHeight() / 2) - this.getHeight() / 2.0f);
    }

    public void center() {
        this.centerX();
        this.centerY();
    }

    public int getHitWidth() {
        return this.hitWidth;
    }

    public int getHitHeight() {
        return this.hitHeight;
    }

    public void setHitWidth(int i) {
        this.hitWidth = i;
    }

    public void setHitHeight(int i) {
        this.hitHeight = i;
    }

    public void setHitTestModifiers(int h, int v) {
        this.hModifier = h;
        this.vModifier = v;
    }

    protected static enum State {
        OVER,
        OUT;

    }
}

