/*
 * Decompiled with CFR 0.152.
 */
package com.newcastleigem.biogame.menus;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.newcastleigem.biogame.biobricks.BioBrick;
import com.newcastleigem.biogame.menus.ListButton;

public class BioBrickButton
extends ListButton {
    private String name;
    private String description;
    private String partNum;
    private BitmapFont titleText;
    private BitmapFont bodyText;

    public BioBrickButton(BioBrick b) {
        super(b.getName(), 600);
        this.name = b.getName();
        this.description = b.getDescription();
        this.partNum = b.getPartNum();
        this.titleText = new BitmapFont();
        this.titleText.setColor(Color.WHITE);
        this.titleText.setScale(3.0f);
        this.bodyText = new BitmapFont();
        this.bodyText.setColor(Color.WHITE);
        this.bodyText.setScale(2.0f);
        this.setHeight(150.0f);
        this.setHitHeight(150);
    }

    @Override
    public void drawText(SpriteBatch batch, float delta) {
        this.titleText.draw(batch, this.name, this.getX() + 5.0f, this.getY() + this.getHeight() - 10.0f);
        this.bodyText.drawWrapped(batch, this.description, this.getX() + 5.0f, this.getY() + this.getHeight() - 10.0f - this.titleText.getLineHeight(), this.getWidth() - 20.0f, BitmapFont.HAlignment.LEFT);
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + "\t" + this.partNum + "\n" + this.description;
    }
}

