/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.lights.BaseLight;
import com.badlogic.gdx.graphics.g3d.lights.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.lights.PointLight;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Lights {
    public final Color ambientLight = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public final Array<DirectionalLight> directionalLights = new Array();
    public final Array<PointLight> pointLights = new Array();

    public Lights() {
    }

    public Lights(Color ambient) {
        this.ambientLight.set(ambient);
    }

    public Lights(float ambientRed, float ambientGreen, float ambientBlue) {
        this.ambientLight.set(ambientRed, ambientGreen, ambientBlue, 1.0f);
    }

    public Lights(Color ambient, BaseLight ... lights) {
        this(ambient);
        this.add(lights);
    }

    public Lights clear() {
        this.ambientLight.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.directionalLights.clear();
        this.pointLights.clear();
        return this;
    }

    public Lights add(BaseLight ... lights) {
        for (BaseLight light : lights) {
            this.add(light);
        }
        return this;
    }

    public Lights add(Array<BaseLight> lights) {
        for (BaseLight light : lights) {
            this.add(light);
        }
        return this;
    }

    public Lights add(BaseLight light) {
        if (light instanceof DirectionalLight) {
            this.directionalLights.add((DirectionalLight)light);
        } else if (light instanceof PointLight) {
            this.pointLights.add((PointLight)light);
        } else {
            throw new GdxRuntimeException("Unknown light type");
        }
        return this;
    }
}

