/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.backends.lwjgl.LwjglGL10;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;

final class LwjglGL11
extends LwjglGL10
implements com.badlogic.gdx.graphics.GL11 {
    private IntBuffer tempInt = BufferUtils.createIntBuffer(8);
    private FloatBuffer tempFloat = BufferUtils.createFloatBuffer(8);

    private IntBuffer toBuffer(int n, int[] src, int offset) {
        if (this.tempInt.capacity() < n) {
            this.tempInt = BufferUtils.createIntBuffer(n);
        } else {
            this.tempInt.clear();
        }
        this.tempInt.put(src, offset, n);
        this.tempInt.flip();
        return this.tempInt;
    }

    private IntBuffer toBuffer(int[] src, int offset) {
        int n = src.length - offset;
        if (this.tempInt.capacity() < n) {
            this.tempInt = BufferUtils.createIntBuffer(n);
        } else {
            this.tempInt.clear();
        }
        this.tempInt.put(src, offset, n);
        this.tempInt.flip();
        return this.tempInt;
    }

    private FloatBuffer toBuffer(float[] src, int offset) {
        int n = src.length - offset;
        if (this.tempFloat.capacity() < n) {
            this.tempFloat = BufferUtils.createFloatBuffer(n);
        } else {
            this.tempFloat.clear();
        }
        this.tempFloat.put(src, offset, src.length - offset);
        this.tempFloat.flip();
        return this.tempFloat;
    }

    @Override
    public void glBindBuffer(int target, int buffer) {
        ARBVertexBufferObject.glBindBufferARB(target, buffer);
    }

    @Override
    public void glBufferData(int target, int size, Buffer data, int usage) {
        if (data instanceof ByteBuffer) {
            GL15.glBufferData(target, (ByteBuffer)data, usage);
        } else if (data instanceof IntBuffer) {
            GL15.glBufferData(target, (IntBuffer)data, usage);
        } else if (data instanceof FloatBuffer) {
            GL15.glBufferData(target, (FloatBuffer)data, usage);
        } else if (data instanceof DoubleBuffer) {
            GL15.glBufferData(target, (DoubleBuffer)data, usage);
        } else if (data instanceof ShortBuffer) {
            GL15.glBufferData(target, (ShortBuffer)data, usage);
        } else if (data == null) {
            GL15.glBufferData(target, size, usage);
        }
    }

    @Override
    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (data instanceof ByteBuffer) {
            GL15.glBufferSubData(target, (long)offset, (ByteBuffer)data);
        } else if (data instanceof IntBuffer) {
            GL15.glBufferSubData(target, (long)offset, (IntBuffer)data);
        } else if (data instanceof FloatBuffer) {
            GL15.glBufferSubData(target, (long)offset, (FloatBuffer)data);
        } else if (data instanceof DoubleBuffer) {
            GL15.glBufferSubData(target, (long)offset, (DoubleBuffer)data);
        } else if (data instanceof ShortBuffer) {
            GL15.glBufferSubData(target, (long)offset, (ShortBuffer)data);
        }
    }

    @Override
    public void glClipPlanef(int plane, float[] equation, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glClipPlanef(int plane, FloatBuffer equation) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        GL15.glDeleteBuffers(this.toBuffer(n, buffers, offset));
    }

    @Override
    public void glDeleteBuffers(int n, IntBuffer buffers) {
        GL15.glDeleteBuffers(buffers);
    }

    @Override
    public void glGenBuffers(int n, int[] buffers, int offset) {
        for (int i = offset; i < offset + n; ++i) {
            buffers[i] = GL15.glGenBuffers();
        }
    }

    @Override
    public void glGenBuffers(int n, IntBuffer buffers) {
        GL15.glGenBuffers(buffers);
    }

    @Override
    public void glGetBooleanv(int pname, boolean[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetBooleanv(int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetBufferParameteriv(int target, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        GL15.glGetBufferParameter(target, pname, params);
    }

    @Override
    public void glGetClipPlanef(int pname, float[] eqn, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetClipPlanef(int pname, FloatBuffer eqn) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetFixedv(int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetFixedv(int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetFloatv(int pname, float[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetFloatv(int pname, FloatBuffer params) {
        GL11.glGetFloat(pname, params);
    }

    @Override
    public void glGetLightfv(int light, int pname, float[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetLightfv(int light, int pname, FloatBuffer params) {
        GL11.glGetLight(light, pname, params);
    }

    public void glGetLightxv(int light, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetLightxv(int light, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetMaterialfv(int face, int pname, float[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetMaterialfv(int face, int pname, FloatBuffer params) {
        GL11.glGetMaterial(face, pname, params);
    }

    public void glGetMaterialxv(int face, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetMaterialxv(int face, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetPointerv(int pname, Buffer[] params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetTexEnviv(int env, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetTexEnviv(int env, int pname, IntBuffer params) {
        GL11.glGetTexEnv(env, pname, params);
    }

    public void glGetTexEnvxv(int env, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetTexEnvxv(int env, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetTexParameterfv(int target, int pname, float[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glGetTexParameter(target, pname, params);
    }

    @Override
    public void glGetTexParameteriv(int target, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        GL11.glGetTexParameter(target, pname, params);
    }

    public void glGetTexParameterxv(int target, int pname, int[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glGetTexParameterxv(int target, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean glIsBuffer(int buffer) {
        return GL15.glIsBuffer(buffer);
    }

    @Override
    public boolean glIsEnabled(int cap) {
        return GL11.glIsEnabled(cap);
    }

    @Override
    public boolean glIsTexture(int texture) {
        return GL11.glIsTexture(texture);
    }

    @Override
    public void glPointParameterf(int pname, float param) {
        GL14.glPointParameterf(pname, param);
    }

    @Override
    public void glPointParameterfv(int pname, float[] params, int offset) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glPointParameterfv(int pname, FloatBuffer params) {
        GL14.glPointParameter(pname, params);
    }

    @Override
    public void glPointSizePointerOES(int type, int stride, Buffer pointer) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void glTexEnvi(int target, int pname, int param) {
        GL11.glTexEnvi(target, pname, param);
    }

    @Override
    public void glTexEnviv(int target, int pname, int[] params, int offset) {
        GL11.glTexEnv(target, pname, this.toBuffer(params, offset));
    }

    @Override
    public void glTexEnviv(int target, int pname, IntBuffer params) {
        GL11.glTexEnv(target, pname, params);
    }

    @Override
    public void glTexParameterfv(int target, int pname, float[] params, int offset) {
        GL11.glTexParameter(target, pname, this.toBuffer(params, offset));
    }

    @Override
    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glTexParameter(target, pname, params);
    }

    @Override
    public void glTexParameteri(int target, int pname, int param) {
        GL11.glTexParameteri(target, pname, param);
    }

    @Override
    public void glTexParameteriv(int target, int pname, int[] params, int offset) {
        GL11.glTexParameter(target, pname, this.toBuffer(params, offset));
    }

    @Override
    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GL11.glTexParameter(target, pname, params);
    }

    @Override
    public void glColorPointer(int size, int type, int stride, int pointer) {
        GL11.glColorPointer(size, type, stride, pointer);
    }

    @Override
    public void glNormalPointer(int type, int stride, int pointer) {
        GL11.glNormalPointer(type, stride, pointer);
    }

    @Override
    public void glTexCoordPointer(int size, int type, int stride, int pointer) {
        GL11.glTexCoordPointer(size, type, stride, pointer);
    }

    @Override
    public void glVertexPointer(int size, int type, int stride, int pointer) {
        GL11.glVertexPointer(size, type, stride, pointer);
    }

    @Override
    public void glDrawElements(int mode, int count, int type, int indices) {
        GL11.glDrawElements(mode, count, type, indices);
    }
}

