/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public interface Net {
    public void sendHttpRequest(HttpRequest var1, HttpResponseListener var2);

    public ServerSocket newServerSocket(Protocol var1, int var2, ServerSocketHints var3);

    public Socket newClientSocket(Protocol var1, String var2, int var3, SocketHints var4);

    public void openURI(String var1);

    public static enum Protocol {
        TCP;

    }

    public static interface HttpResponseListener {
        public void handleHttpResponse(HttpResponse var1);

        public void failed(Throwable var1);
    }

    public static class HttpRequest {
        private final String httpMethod;
        private String url;
        private Map<String, String> headers;
        private int timeOut = 0;
        private String content;
        private InputStream contentStream;
        private long contentLength;

        public HttpRequest(String httpMethod) {
            this.httpMethod = httpMethod;
            this.headers = new HashMap<String, String>();
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setContent(InputStream contentStream, long contentLength) {
            this.contentStream = contentStream;
            this.contentLength = contentLength;
        }

        public void setTimeOut(int timeOut) {
            this.timeOut = timeOut;
        }

        public int getTimeOut() {
            return this.timeOut;
        }

        public String getMethod() {
            return this.httpMethod;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContent() {
            return this.content;
        }

        public InputStream getContentStream() {
            return this.contentStream;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    public static interface HttpMethods {
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
    }

    public static interface HttpResponse {
        public byte[] getResult();

        public String getResultAsString();

        public InputStream getResultAsStream();

        public HttpStatus getStatus();
    }
}

