#ifndef USB_WRAPPER_H
#define USB_WRAPPER_H

#include <string>
#include <vector>
#include <cstdint>
#include <exception>
#include <libusb-1.0/libusb.h>

using namespace std;

class usbexception : public exception
{
    public:
        usbexception(const string &err) : m_err(string("USB exception : ") + err) {}
        virtual const char* what() const throw()
        {
            return m_err.c_str();
        }
    private:
        const string m_err;
};

class usb_wrapper
{
    public:
        usb_wrapper(const int vendor, const string &vendorName, const int product, const string &productName);
        inline explicit operator bool() const { return (m_handle); }
        size_t request(const uint8_t bRequest, const uint16_t wValue, const uint16_t wIndex, vector<unsigned char>&retbuf, unsigned int timeout= 5000);
        ~usb_wrapper();

    private:
        libusb_device_handle *m_handle;
};

#endif // USB_WRAPPER_H
