#ifndef PCR_DEVICE_H
#define PCR_DEVICE_H

#include <cstdint>
#include "usb_wrapper.h"

class pcr_device_exception : public exception
{
    public:
        pcr_device_exception(const string &err, const exception &ex) : m_err(string("Device exception : ") + err + string("\n \t <= ") + ex.what()) {}
        pcr_device_exception(const string &err) : m_err(string("Device exception : ") + err) {}
        virtual const char* what() const throw()
        {
            return m_err.c_str();
        }
    private:
        const string m_err;
};

class pcr_device
{
    public:
        pcr_device();
        ~pcr_device();

        double get_block_Tsensor(const unsigned int n_mean= 3);
        double get_lid_Tsensor(const unsigned int n_mean= 3);
        void set_block_heater(double power);
        void set_lid_heater(double power);

    private:
        void set_led(const bool on);
        uint16_t get_adc(const uint8_t which);

        const int vendorID=  0x16C0;
        const int productID= 0x05DC; //Use obdev's generic shared VID/PID pair and follow the rules outlined in USBID-License.txt.
        const string vendorName= "Damir Vodenicarevic";
        const string productName= "PCR system";



        const uint8_t CMD_LED= 0;
        const uint8_t CMD_READ_AD= 1;
        const uint8_t CMD_HEATER_BLOCK= 2;
        const uint8_t CMD_HEATER_LID= 3;

        const uint16_t HEATER_OFF= 0;
        const uint16_t HEATER_HEAT= 1;
        const uint16_t HEATER_COOL= 2;

        const uint8_t ADC_BLOCK= 0;
        const uint8_t ADC_LID= 1;

        const uint16_t adc_max= 65472;
        const uint16_t pwm_max= 8191;

        usb_wrapper m_usb;
};

#endif // PCR_DEVICE_H
