function PlotPlasmDistribution(GillResult,timesample,resolution)

Plasmids=GillResult{1};
Ntsamples=length(timesample)-1;

for Ts=1:Ntsamples
    SubPlasm=Plasmids(:,((Plasmids(2,:)>=timesample(Ts) & Plasmids(2,:)<timesample(Ts+1))));
    [n,freq]=hist(SubPlasm,resolution);
    figure;
    plot(freq,n/sum(n),'.k');
    title(strcat('Plasmid Distribution for cells born between ',num2str(timesample(Ts)),' h and ',num2str(timesample(Ts+1)),' h'));
    xlabel('# of plasmids/cell')
    ylabel('Frequency')
end

end