% Calculate RBS strengths from GFP expression data
% using data from both experiments
function prod_out = calc_rbs_strengths()
    % matlab code exported by Gen5Parser
    d = load('rbs.mat'); d.name = 'Exp1';
    % .5 hour till 3 hour: 
    measure_range = 8:15;
%    measure_range = 25:96; % stationary state
    test_range = 1:72;
    x = (1:size(d.data,1)).* ( 1/6 );
    sampletimes = (0:length(measure_range)-1) * 10;

    strains = {
        'K398500A'
        'K398501A'
        'K398502A'
        'K398503A'
        'K398504A'
        'K173000A'
        'I13401'
        'LB+Amp/J13002'
    };

    rbsname = {
        'J61100' % A 1
        'J61101' % B 2
        'J61107' % C 3 
        'J61117' % D 4
        'J61127' % E 5
        'B0032'  % F 6
        'fluor blank' % G 7
        'mixed' % H 8
    };

    function d = proc_exp_data(sd, blank_cols)
        d.gfp = sd.data(:, 1:96);
        d.od = sd.data(:, 97:192);
        
        % mean blank GFP for each data row
        abs_blank_gfp = mean(d.gfp(:, blank_cols), 2);
        abs_blank_od = mean(d.od(:, blank_cols), 2);
        
        fprintf('%s has blank GFP: %f, OD: %f\n', ...
            sd.name, mean(abs_blank_gfp), mean(abs_blank_od));

        % subtract blank LB GFP and OD
        d.gfp(:, 1:(12*7)) = d.gfp(:, 1:(12*7)) - repmat(abs_blank_gfp, 1, 12*7);
        d.od(:, 1:(12*7)) = d.od(:, 1:(12*7)) - repmat(abs_blank_od, 1, 12*7);
        
        % control plasmid (GFP without promotor+rbs)
        % this shows that general biomass also results in a gfp measurement
        ctl_gfp = d.gfp(:, 73:84);
        ctl_od = d.od(:, 73:84);
    
        %plot (x, [ctl_od * 500 ctl_gfp]);

        % calculate how much GFP is measured per biomass, without GFP being
        % actually present
        d.fake_gfp_per_od = mean(mean(ctl_gfp ./ ctl_od));

        fprintf('GFP / biomass in control plasmid: %f\n', d.fake_gfp_per_od);
        d.corrected_gfp = d.gfp(:, 1:72) - (d.fake_gfp_per_od * d.od(:, 1:72));

        d.gfp_od = d.corrected_gfp ./ d.od(:, 1:72);
%        d.gfp_od = d.gfp(:,1:72) ./ d.od(:, 1:72);
% figure(1);
% plot (x, gfp_od_data);
%    xlabel ('Time (hours)');
%    ylabel ('Fluorescence (GFP) / absorbance (biomass)');

   % figure(3);
   % plot (x, od_data);
%    xlabel ('Time (hours)');
%    ylabel ('Absorbance (biomass)');
     
        production = zeros(length(test_range), 1);    
        for i = test_range
            % timestep in minutes
            duration = length(measure_range-1) * 10;
            od = d.od(measure_range, i);
            gfp = d.gfp_od(measure_range, i);

            [prod, mu] = calc_production(gfp', od', duration);
            production(i) = prod;

            fprintf('Found beta=%f, mu=%f\n', prod, mu);
        end
        d.prod = production';
    end % of function

    % process each experiment individually, then combine results
    d = proc_exp_data(d, 85:96);
   % d2 = proc_exp_data(d2, 94:96);

    mprod_ref = mean(d.prod((1:12) + (6-1)*12));
    for i=1:6
        indices = (1:12) + (i-1)*12;
        prod_rbs = [d.prod(indices)];% d2.prod(indices)];
        strengths = .3 * (prod_rbs ./ mprod_ref);
        prod_out(:, i) = strengths;
        strength_mean = mean(strengths);
        strength_std = std(strengths);
        fprintf('RBS avg %s strength = %f, std deviation: %f, %d samples \n', rbsname{i}, strength_mean, strength_std, length(prod_rbs));
    end
    figure(2);
    boxplot(prod_out, rbsname(1:6));
    ylabel('Relative RBS strength');
end
