% Calculate the protein production
% (based on model:
%  http://2010.igem.org/Team:TU_Delft/Project/rbs-characterization/characterization)
%
% Input:
%   n rows of GFP and n rows of OD data
%   duration in minutes
% Output:
%   A production value (prod) and growth rate (mu)
function [prod, mu] = calc_production(gfp, od, duration)
    % GFP degradation rate
    k_deg = log(2)/(41*60);
    
    % find growth rate mu by curve fitting the OD data

    calc_od = @(p,t) p(1)*exp(p(2)*t);

    timestep = duration / length(od);
    sampletimes = 0 : timestep : (duration - timestep);

    % initial guess for OD fitting
    od_param_initial = [od(1) log(od(end)/od(1)) / duration];
    od_param = lsqcurvefit(calc_od, od_param_initial, sampletimes, od);
    alpha = od_param(2) + k_deg;
    mu = od_param(2);

    calc_gfp = @(p, t) ...
        (p(1) / alpha + exp(-alpha * t) * (p(2) - p(1)/alpha));

    % initial guess for GFP fitting
    e = exp(alpha * timestep);
    beta = alpha * (gfp(end) - gfp(1)/e)/(e - 1);

    % fit GFP
    gfp_param_initial = [beta 0];
    gfp_param = lsqcurvefit(calc_gfp, gfp_param_initial, sampletimes, gfp);

    prod = gfp_param(1);
end
