#!/usr/bin/perl
# Modify the variables if necessary.
# $dir is the directory which you put in the files to be uploaded.
$dir = "upload";

# $siteType is about the site type:
# 1 is for iGEM 2009 Team Wiki
# 2 is for a general MediaWiki site
$siteType = 1;

if($siteType == 1)																# 1 is for iGEM 2009 Team Wiki, you should put in your username & password.
{
	$username = "";																# ! Put in your username to log in iGEM 2009 Team Wiki
	$password = "";																# ! Put in your password to log in iGEM 2009 Team Wiki
	$loginUrl = "http://ung.igem.org/Login";							# This is the url to post to for logging in. You don't need to change it
	$uploadUrl  = "http://2009.igem.org/Special:Upload";		# This is the url to post to for file uploading. You don't need to change it
	$formUsername = "username";										# Post key for username. You don't need to change it
	$formPassword = "password";											# Post key for password. You don't need to change it
	$loginStr = "Login";															# Post key for login. You don't need to change it
}
elsif ($siteType == 2)															# 2 is for a general MediaWiki site, you don't need to change the variables below if not necessary.
{
	$siteBase ="http://localhost/wiki";									# Put in the url where this site is installed. For example: http://www.mediawiki.org/wiki 
	$username = "";																# Put in your username to log in this site
	$password = "";																# Put in your password to log in this site
	$loginUrl = $siteBase . "/wiki/index.php?title=Special:Userlogin&action=submitlogin";
	$uploadUrl = $siteBase . "/wiki/Special:Upload";
	$formUsername = "wpName";
	$formPassword = "wpPassword";
	$loginStr = "wpLoginAttempt";										# You may not need to change the other variables.
}

# We need these libraries. They should be part of a standard Perl
use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use HTTP::Cookies;
use Encode qw(encode);

my $browser=LWP::UserAgent->new();
  my @ns_headers = (
   'User-Agent' => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.7) Gecko/20041107 Firefox/1.0',
   'Accept' => 'image/gif, image/x-xbitmap, image/jpeg, 
        image/pjpeg, image/png, */*',
   'Accept-Charset' => 'iso-8859-1,*,utf-8',
   'Accept-Language' => 'en-US',
  );

# Post to Login
$browser->cookie_jar( {} );
$response=$browser->post($loginUrl, @ns_headers, Content=>[$formUsername=>$username,$formPassword=>$password,wpRemember=>"1",$loginStr=>"Log in"]);

# For iGEM 2009 Team Wiki, we need redirect to partsregistry.org as the 2nd step of logging in.
if($siteType == 1)
{
	$response=$browser->get($response->header( "location" ), @ns_headers);
}

if($response->code!=302) {
	print 
"We weren't able to login. This could have the following causes:
* The username ($username) or password may be incorrect.
  Solution: Edit upload.pl and change them.
  Script stopped. You can close the window or press [Ctrl] + [C].\n";
  	debug();
	sleep(3600);
	exit 1;
}
print "Login successfully!\n";

opendir DIRH, $dir or die "couldn't open $dir: $!"; 
my @dir = readdir DIRH; 
closedir DIRH;
for $file (@dir) { 
	next if $file eq '.' or $file eq '..'; 
	if (-f "$dir/$file") { 
		$eckey=encode('utf8',$file);
		uploadfile:
		$response=$browser->post($uploadUrl, @ns_headers,Content_Type=>'form-data',Content=>
		[
			wpUploadFile=>["$dir/$eckey"],
			wpUploadDescription=>"",
			wpDestFile=>$eckey,
			# wpUploadAffirm=>"1",
			wpUpload=>"Upload file",
			wpIgnoreWarning=>"1"
		]);
		push @responses,$response->as_string;
		if($response->code!=302 && $response->code!=200) {
			print "Upload $eckey failed! Will try again. Output was:\n";
			print $response->as_string;
			goto uploadfile;
		} else {
			print "$eckey uploaded successfully.\n";
		}
   		next; 
	}; 
}
print "Mission finished. You can close the window or press [Ctrl] + [C].\n";

sub debug() {
  	open(DEBUG,">debug.txt") or die "Could not write file.\n";
	print DEBUG $response->as_string;
	close(DEBUG);
}
sleep(3600);