% TU DElft iGEM team
% Oct 2008
% Bifurcation and sensitivity analysis

clc
clear all
close all
syms Acetyl_CoA Phytoene...
    Lycopene B_Carotene Zeaxanthin...
    e_tot CrtB CrtI CrtY CrtZ real;
syms Kt Vt K1 V1 K2 V2 K3 V3 d1 d2...
    d3 d4 Kcat_t Kcat1 Kcat2 Kcat3...
    Ke1 T1 m1 alpha1 Ki1 p1...
    Ke2 T2 m2 alpha2 Ki2 p2...
    Ke3 T3 m3 alpha3 Ki3 p3 real;

Vt=Kcat_t*e_tot;
V1=Kcat1*CrtI;
V2=Kcat2*CrtY;
V3=Kcat3*CrtZ;

R0 = Vt*Acetyl_CoA/(Kt+Acetyl_CoA);
R1 = V1*Phytoene/(K1+Phytoene);
R2 = V2*Lycopene/(K2+Lycopene);
R3 = V3*B_Carotene/(K3+B_Carotene);
R4 = d1*Phytoene;
R5 = d2*Lycopene;
R6 = d3*B_Carotene;
R7 = d4*Zeaxanthin;

xdot=[
    %R0-R0
    R0-R1-R4
    R1-R2-R5
    R2-R3-R6
    R3-R7];

CrtI=alpha1*T1^m1/((T1^m1+Ke1^m1)*(T1^p1+Ki1^p1))+1;
CrtY=alpha2*T2^m2/((T2^m2+Ke2^m2)*(T2^p2+Ki2^p2))+1;
CrtZ=alpha3*T3^m3/((T3^m3+Ke3^m3)*(T3^p3+Ki3^p3))+1;


% J_enz = jacobian (xdot, [e_tot CrtI CrtY CrtZ]);

% stab_sub=eig(J_sub);
% stab_enz=eig(J_enz);

xdot=subs(xdot)

J_sub = jacobian (xdot, [Phytoene Lycopene B_Carotene Zeaxanthin]);

J_enz_hill = jacobian (xdot, [alpha1 m1 Ke1 Ki1 p1 alpha2 m2 Ke2 Ki2 p2 alpha3 m3 Ke3 Ki3 p3  ]);

alpha1= 23e12; m1=17; Ke1=34.20; Ki1=23.71; p1=8;
alpha2= 2e40; m2=25; Ke2=28.78; Ki2=39.25; p2=25;
alpha3= 1e23; m3=35; Ke3=37.04; Ki3=7.2; p3=14;
Acetyl_CoA=0.1; Phytoene=0.1; Lycopene=0.1; B_Carotene=0.1; Zeaxanthin=0.1; e_tot=0.1;
Kt=random('unif',0.001,0.0374);         % the upper and lower limits are based on the brenda database  
K1=random('unif',0.001,0.0374); 
K2=random('unif',0.001,0.0374);
K3=random('unif',0.001,0.0374);
d1=0.01; d2=0.01; d3=0.01; d4=0.01; 
Kcat_t=random('unif',0.001,0.0374);    % the upper and lower limits are based on the brenda database
Kcat1=random('unif',0.001,0.0374);
Kcat2=random('unif',0.001,0.0374);
Kcat3=random('unif',0.001,0.0374)
T1=27; T2=30; T3=37;

% J_sub = jacobian (xdot, [Phytoene Lycopene B_Carotene Zeaxanthin]);
% J_enz = jacobian (xdot, [e_tot CrtI CrtY CrtZ]);

stab_sub=eig(J_sub);
% stab_enz=eig(J_enz);

J_enz_hill=subs(J_enz_hill)
stab_sub1=subs(stab_sub)