#ifndef LATTICESITE_H
#define LATTICESITE_H

#include <map>
#include <vector>
#include "definition.h"
#include "Point.h"

using namespace std;

class LatticeSite{

	public:
		
		// Constructor and Destructor for the Lattice Site
		LatticeSite(Point &);
		~LatticeSite();
		
		
		// Get the location of the Lattice Site
		Point * getLocation();
		
		// Get the environemnt of the Lattice Site
		moltype getEnvironment();

		// Set the environment of the site to the specified type
		void setEnvironment(envtype);
		
		// Display properties of the Lattice Site
		void display();

		int getID();

		map <int, vector<LatticeSite *> > neighbors;

	private:

		static int auto_id;
	
		int id;

		// Positon/Location of the Lattice Site
		Point pos;
		
		// Environment of the Lattice Site
		envtype environment;
		
}
;

#endif
