#include "LatticeSite.h"

int LatticeSite::auto_id = 0;

//////////////////////////////////////////////////////////////////////
//  Constructor for the Lattice Environment
//
LatticeSite :: LatticeSite(Point & pt){

	id = auto_id;
	auto_id ++;

	// Default Environment
	environment = ENV_CYTOSOL;

	// Position of the Lattice Site
	pos.x = pt.x;	pos.y = pt.y;	pos.z = pt.z;
}



//////////////////////////////////////////////////////////////////////
//  Destructor for the Lattice Site
//
LatticeSite :: ~LatticeSite(){}



//////////////////////////////////////////////////////////////////////
//  Get the environment of the Lattice Site
//
int LatticeSite :: getEnvironment(){

	// return the environment of the Lattice Site
	return environment;
}



//////////////////////////////////////////////////////////////////////
//  Set the Lattice Site to have the specified environment
//
void LatticeSite :: setEnvironment(envtype envType){

	// Set the environment to 'envType'
	environment = envType;
}



//////////////////////////////////////////////////////////////////////
//  Display different concentrations at the Lattice Site
//
void LatticeSite :: display(){

}


int LatticeSite :: getID(){
	return id;
}

//////////////////////////////////////////////////////////////////////
//  Get the location of the Lattice Site
//
Point * LatticeSite :: getLocation(){
	return & pos;
}

//////////////////////////////////////////////////////////////////////
