#include "Enzyme.h"



//////////////////////////////////////////////////////////////////////
// Constructor for the Enzyme object
//

Enzyme::Enzyme(moltype t) : IntracellularMolecule(){
	type = t;
	init();
}

Enzyme::Enzyme(moltype t, Point & loc) : IntracellularMolecule(loc){
	type = t;
	init();
}


//////////////////////////////////////////////////////////////////////
// Destructor for the Enzyme object
//
Enzyme::~Enzyme(){

	// Destructing the Enzyme
	printf("Deleting Enzyme\n");
}


//////////////////////////////////////////////////////////////////////
// Get group
//
int Enzyme::getGroup(){
	return MOL_GROUP_ENZYME;
}



//////////////////////////////////////////////////////////////////////
// Get group name
//
string Enzyme::getGroupName(){
	return MOL_GROUP_NAME_ENZYME;
}

moltype Enzyme::getType(){
	switch(type){
		case MOL_ENZYME_A:
			return MOL_ENZYME_A;
			break;
		case MOL_ENZYME_B:
			return MOL_ENZYME_B;
			break;
		case MOL_ENZYME_C:
			return MOL_ENZYME_C;
			break;
		case MOL_ENZYME_D:
			return MOL_ENZYME_D;
			break;
		case MOL_ENZYME_E:
			return MOL_ENZYME_E;
			break;
	}
}

string Enzyme::getTypeName(){
	switch(type){
		case MOL_ENZYME_A:
			return MOL_NAME_ENZYME_A;
			break;
		case MOL_ENZYME_B:
			return MOL_NAME_ENZYME_B;
			break;
		case MOL_ENZYME_C:
			return MOL_NAME_ENZYME_C;
			break;
		case MOL_ENZYME_D:
			return MOL_NAME_ENZYME_D;
			break;
		case MOL_ENZYME_E:
			return MOL_NAME_ENZYME_E;
			break;
	}
}

void Enzyme :: init(){
  const static float REACTION_SPEED_FACTOR = 1.0e3;

	switch(type){
		case MOL_ENZYME_A:
			mobility = 10.0;
			reactant = META_A;
			product = META_B;
			reactionRate = 0.2;
			forwardReactionRate = getI("FORWARD_REACTION_RATE_A") / 1000.0 / 1000.0;
			reverseReactionRate = getI("REVERSE_REACTION_RATE_A") / 1000.0 / 1000.0;
			equilibriumConstant = getI("EQUILIBRIUM_CONSTANT_A") / 1000.0;
			maximumRate = getI("MAXIMUM_RATE_A") / 1000.0 / 6.02e23 * REACTION_SPEED_FACTOR;
			break;
		case MOL_ENZYME_B:
			mobility = 0.0;
			reactant = META_B;
			product = META_C;
			reactionRate = 0.2;
			forwardReactionRate = getI("FORWARD_REACTION_RATE_B") / 1000.0 / 1000.0;
			reverseReactionRate = getI("REVERSE_REACTION_RATE_B") / 1000.0 / 1000.0;
			equilibriumConstant = getI("EQUILIBRIUM_CONSTANT_B") / 1000.0;
			maximumRate = getI("MAXIMUM_RATE_B") / 1000.0 / 6.02e23 * REACTION_SPEED_FACTOR;
			break;
		case MOL_ENZYME_C:
			mobility = 1.0;
			reactant = META_C;
			product = META_D;
			reactionRate = 0.2;
			forwardReactionRate = getI("FORWARD_REACTION_RATE_C") / 1000.0 / 1000.0;
			reverseReactionRate = getI("REVERSE_REACTION_RATE_C") / 1000.0 / 1000.0;
			equilibriumConstant = getI("EQUILIBRIUM_CONSTANT_C") / 1000.0;
			maximumRate = getI("MAXIMUM_RATE_C") / 1000.0 / 6.02e23 * REACTION_SPEED_FACTOR;
			break;
		case MOL_ENZYME_D:
			mobility = 1.0;
			reactant = META_D;
			product = META_E;
			reactionRate = 0.2;
			forwardReactionRate = getI("FORWARD_REACTION_RATE_D") / 1000.0 / 1000.0;
			reverseReactionRate = getI("REVERSE_REACTION_RATE_D") / 1000.0 / 1000.0;
			equilibriumConstant = getI("EQUILIBRIUM_CONSTANT_D") / 1000.0;
			maximumRate = getI("MAXIMUM_RATE_D") / 1000.0 / 6.02e23 * REACTION_SPEED_FACTOR;
			break;
		case MOL_ENZYME_E:
			mobility = 1.0;
			reactant = META_E;
			product = META_E;
			reactionRate = 0.2;
			forwardReactionRate = getI("FORWARD_REACTION_RATE_E") / 1000.0 / 1000.0;
			reverseReactionRate = getI("REVERSE_REACTION_RATE_E") / 1000.0 / 1000.0;
			equilibriumConstant = getI("EQUILIBRIUM_CONSTANT_E") / 1000.0;
			maximumRate = getI("MAXIMUM_RATE_E") / 1000.0 / 6.02e23 * REACTION_SPEED_FACTOR;
			break;
	}
}
