/*
===============================================================================
	Headers
===============================================================================
*/

#include <iostream>

using namespace std;

#ifdef GRAPHICS
// These are the GLOW headers used by this program
#include "glow.h"
#include "glowLabelWidget.h"
#include "glowPushButtonWidget.h"
#include "glowRadioButtonWidget.h"
#include "glowCheckBoxWidget.h"
#include "glowTextFieldWindow.h"
#include "glowViewTransform.h"
#include <GL/glut.h>
#include <GL/gl.h>

GLOW_NAMESPACE_USING
#endif /* GRAPHICS */

#include <stdio.h>
#include <string>
#include <map>
#include <vector>

#include "Molecule.h"
#include "Matrix.h"
#include "GenSimulation.h"
#include "functionLib.h"
#include "ParameterManager.h"
#include "LatticeEnvironment.h"
#include "SimEngine.h"

#ifdef GRAPHICS
#include "SimWindow.h"
#endif /* GRAPHICS */
ParameterManager * pm = ParameterManager::getParameterManager();

// Dimensions of the Lattice
int xDim = pm->get("X_DIM");
int yDim = pm->get("Y_DIM");
int zDim = pm->get("Z_DIM");

int numLatticeSites = xDim * yDim * zDim;
int numEnvironments= 5;
float resolution = 0.25;

double TIMESCALE = 5.0e-6;
/* The length of time that one timestep represents, in seconds */

double SPACESCALE = 5.0e-8; /* 10^-7 sized lattice cells means that 10 of them makes up about the diameter of an E. coli cell */
/* The distance between neighbouring lattice cells, in metres */


int concType = -1;
int showEnvType = -1;

SimEngine * simulation;
#ifdef GRAPHICS
SimDisplayWindow * sub;
StatsWindow * stats;
SimWindow * simWin;
#endif /* GRAPHICS */

void simulate(){

	simulation->simulate();
	if(simulation->continueSimulation){
#ifdef GRAPHICS
		sub->Refresh();
		stats->Refresh();
#endif /* GRAPHICS */
		// Pause simulation every specific number of cycles
//		if(simulation->cell->getCycles() % 5 == 0){
//			simWin->cb_continueSimulation->SetState(GlowCheckBoxWidget::off);
//			simulation->continueSimulation = false;
//		}
	}
}

/*
===============================================================================
	Entry point
===============================================================================
*/


int main(int argc, char **argv)
{
	bool graphicsArg = false;

	for (int i = 1; i < argc; i++)
		if (strcmp(argv[i], "-g") == 0)
	                graphicsArg = true;

	if (graphicsArg) {
#ifdef GRAPHICS
		glutInit(&argc, argv);
		simWin = new SimWindow();
		simulation = new SimEngine();

		simWin->setup();
	
		Glow::MainLoop();
#endif /* GRAPHICS */
	}
	else {
		simulation = new SimEngine();
		simulation->continueSimulation = true;

		while (1) { simulation->simulate(); }
	}

	return 0;
}
