#ifndef IntracellularMolecule_H
#define IntracellularMolecule_H

#include <stdio.h>
#include <iostream>
#include <string>
#include <time.h>
#include "Molecule.h"
#include "RandomNG.h"
#include "definition.h"
#include "functionLib.h"

class Vector3D;

class IntracellularMolecule: public Molecule{

	public:
	
		//////////////////////////////////////////////////////////////////////
		// Constructor and Destructor
		IntracellularMolecule();
		IntracellularMolecule(Point &);
		virtual ~IntracellularMolecule();

		//////////////////////////////////////////////////////////////////////
		// Operations on the IntracellularMolecule		
		
		//////////////////////////////////////////////////////////////////////
		// Virtual Methods
		
		// Get the type name of the IntracellularMolecule
		virtual string getTypeName() = 0;
		
		// Get the type of the IntracellularMolecule
		virtual moltype getType() = 0;
		
		// Get the group name of the molecule
		virtual string getGroupName();
		
		// Get the Group of the molecule
		virtual int getGroup();
		
		virtual void move();
		void move_recursive(float distance);
		int find_lattice_intersections(float intersections [], Point pos, Vector3D translation);
		int find_lattice_intersections_one_axis(
		  float intersections [],
		  float pos_one_axis,
		  float translation_one_axis,
		  float translation_magnitude,
		  int num_intersections);

		static int compare_float (const void * va, const void * vb);

		//virtual void activate(Molecule *);

	protected:

		//////////////////////////////////////////////////////////////////////
		// Member variables
			
		// The Parameter Manager
		ParameterManager *pm;
		
	
}
;

#endif
